/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEndRod;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.attained.AttainedDrops2;
import shadows.attained.blocks.BulbType;
import shadows.placebo.client.IHasModel;
import shadows.placebo.itemblock.ItemBlockBase;

public class BlockBulb
extends BlockBush
implements IHasModel,
IShearable {
    public static final PropertyEnum<BulbType> BULB = PropertyEnum.func_177709_a((String)"type", BulbType.class);
    public static final AxisAlignedBB BULB_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.5, 0.6875);

    public BlockBulb(String name) {
        this.setRegistryName(name);
        this.func_149663_c("attaineddrops2." + name);
        this.func_149647_a(AttainedDrops2.TAB);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.4f);
        this.func_149675_a(false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(BULB, (Comparable)((Object)BulbType.BLAZE)));
        AttainedDrops2.INFO.getBlockList().add(this);
        AttainedDrops2.INFO.getItemList().add(new ItemBlockBase((Block)this){

            public int func_77647_b(int damage) {
                return damage;
            }

            public String func_77667_c(ItemStack stack) {
                return this.field_150939_a.func_149739_a() + "." + BulbType.values()[stack.func_77960_j()].func_176610_l();
            }
        }.func_77627_a(true));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BulbType b : BulbType.values()) {
            list.add((Object)b.get());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextFloat() >= 0.6937f) {
            EnumDyeColor color = ((BulbType)((Object)state.func_177229_b(BULB))).getColor();
            ParticleEndRod p = new ParticleEndRod((World)Minecraft.func_71410_x().field_71441_e, (double)pos.func_177958_n() + 1.0 - rand.nextDouble(), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 1.0 - rand.nextDouble(), 0.0, 0.03, 0.0);
            p.func_187146_c(color.func_193350_e());
            p.func_187145_d(color.func_193350_e());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ((BulbType)((Object)state.func_177229_b(BULB))).get();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack bulb = ((BulbType)((Object)state.func_177229_b(BULB))).get();
        drops.add((Object)bulb);
        if (fortune > 0 && RANDOM.nextInt(MathHelper.func_76125_a((int)(4 - fortune), (int)1, (int)4)) == 0) {
            drops.add((Object)bulb.func_77946_l());
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BULB, (Comparable)((Object)BulbType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((BulbType)((Object)state.func_177229_b(BULB))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BULB});
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BULB_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return !world.func_175623_d(pos.func_177977_b());
    }

    public void initModels(ModelRegistryEvent e) {
        for (BulbType b : BulbType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)b.ordinal(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "type=" + b.func_176610_l()));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Arrays.asList(((BulbType)((Object)world.func_180495_p(pos).func_177229_b(BULB))).get());
    }
}

