/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import shadows.attained.AttainedDrops2;
import shadows.attained.blocks.BlockBulb;
import shadows.attained.blocks.BlockVitalized;
import shadows.attained.blocks.BulbType;
import shadows.attained.init.Config;
import shadows.attained.init.ModRegistry;
import shadows.attained.util.ParticleMessage;
import shadows.placebo.client.IHasModel;

public class BlockPlant
extends BlockBush
implements IGrowable,
IHasModel {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final PropertyInteger CHARGE = PropertyInteger.func_177719_a((String)"charge", (int)0, (int)4);
    public static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.125, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.25, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.375, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.5, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.625, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.75, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.875, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 1.0, 0.84375)};

    public BlockPlant() {
        this.setRegistryName("attaineddrops2", "plant");
        this.func_149663_c("attaineddrops2.plant");
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185850_c);
        AttainedDrops2.INFO.getBlockList().add(this);
        AttainedDrops2.INFO.getItemList().add(new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return this.func_185514_i(world.func_180495_p(pos.func_177977_b()));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return Config.allowBonemeal && !this.isMaxAge(state);
    }

    public void getDrops(NonNullList<ItemStack> ret, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if ((double)ThreadLocalRandom.current().nextFloat() >= 0.3) {
            ret.add((Object)new ItemStack(ModRegistry.SEED));
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModRegistry.SOIL;
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean bool) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModRegistry.SOIL) {
            int age = this.getAge(world.func_180495_p(pos));
            return age < this.getMaxAge() || world.field_73012_v.nextInt(1 + (Integer)state.func_177229_b((IProperty)CHARGE)) == 0 && this.isMaxAge(state) && world.func_175623_d(pos.func_177984_a());
        }
        return false;
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        IBlockState place;
        int age = this.getAge(state);
        if (age < this.getMaxAge()) {
            this.setAge(world, pos, this.getAge(state) + 1);
        }
        if (this.isMaxAge(state) && world.func_175623_d(pos.func_177984_a()) && (place = BlockVitalized.getBulbFromState(world.func_180495_p(pos.func_177977_b()))) != null) {
            AttainedDrops2.NETWORK.sendToAllAround((IMessage)new ParticleMessage(((BulbType)((Object)place.func_177229_b(BlockBulb.BULB))).getColor(), pos.func_177984_a(), 1), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0));
            world.func_175656_a(pos.func_177984_a(), place);
            int charge = (Integer)state.func_177229_b((IProperty)CHARGE);
            world.func_175656_a(pos, state.func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(charge + 1 > 4 ? 0 : charge + 1)));
            if (charge > 0 && rand.nextInt(5 - charge) == 0) {
                world.func_175656_a(pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()).func_177230_c().func_176223_P());
                world.func_175656_a(pos, state.func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(0)));
                if (Config.revertToDirt && rand.nextInt(8 - charge) == 0) {
                    if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == ModRegistry.BULB) {
                        world.func_175655_b(pos.func_177984_a(), true);
                    }
                    world.func_175656_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
                    AttainedDrops2.NETWORK.sendToAllAround((IMessage)new ParticleMessage(EnumDyeColor.RED, pos.func_177984_a(), 2), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0));
                }
            }
        }
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (this.func_176473_a(world, pos, state, true)) {
            this.func_176474_b(world, world.field_73012_v, pos, state);
        } else if (!this.func_176473_a(world, pos, state, true) && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockDirt && (Integer)state.func_177229_b((IProperty)AGE) > 0) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) - 1)));
        }
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModRegistry.SEED);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = meta > 7 ? state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7)).func_177226_a((IProperty)CHARGE, (Comparable)Integer.valueOf(meta - 7)) : this.withAge(meta);
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int k = (Integer)state.func_177229_b((IProperty)AGE);
        if (k == 7) {
            k += ((Integer)state.func_177229_b((IProperty)CHARGE)).intValue();
        }
        return k;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, CHARGE});
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    private void setAge(World world, BlockPos pos, int age) {
        world.func_180501_a(pos, this.withAge(age), 2);
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= this.getMaxAge();
    }
}

