/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.integration;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import shadows.attained.blocks.BlockBulb;
import shadows.attained.blocks.BlockCreator;
import shadows.attained.blocks.BlockPlant;
import shadows.attained.blocks.BlockVitalized;
import shadows.attained.blocks.BulbType;
import shadows.attained.blocks.SoilType;
import shadows.attained.init.ModRegistry;

public class Waila {
    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerStackProvider((IWailaDataProvider)new Provider(), BlockVitalized.class);
        registrar.registerStackProvider((IWailaDataProvider)new Provider(), BlockBulb.class);
        registrar.registerStackProvider((IWailaDataProvider)new Provider(), BlockPlant.class);
        registrar.registerBodyProvider((IWailaDataProvider)new Provider(), BlockPlant.class);
        registrar.registerBodyProvider((IWailaDataProvider)new Provider(), BlockVitalized.class);
        registrar.registerBodyProvider((IWailaDataProvider)new Provider(), BlockCreator.class);
    }

    public static class Provider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (accessor.getBlock() != null) {
                IBlockState state = accessor.getWorld().func_180495_p(accessor.getPosition());
                Block block = state.func_177230_c();
                if (block instanceof BlockVitalized) {
                    return ((SoilType)((Object)state.func_177229_b(BlockVitalized.SOIL))).get();
                }
                if (block instanceof BlockBulb) {
                    return ((BulbType)((Object)state.func_177229_b(BlockBulb.BULB))).get();
                }
                if (block instanceof BlockPlant) {
                    return new ItemStack(block, 1, 0);
                }
            }
            return null;
        }

        public List<String> getWailaBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (accessor.getBlock() != null) {
                BlockPos pos = accessor.getPosition();
                World world = accessor.getWorld();
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof BlockPlant) {
                    currenttip.add(I18n.func_135052_a((String)"tooltip.attaineddrops2.growth", (Object[])new Object[0]) + " " + (int)(100.0f * ((float)((Integer)state.func_177229_b((IProperty)BlockPlant.AGE)).intValue() / (float)((BlockPlant)ModRegistry.PLANT).getMaxAge())) + "%");
                    int k = (int)(100.0f * (1.0f / (5.0f - (float)((Integer)state.func_177229_b((IProperty)BlockPlant.CHARGE)).intValue())));
                    currenttip.add(I18n.func_135052_a((String)"tooltip.attaineddrops2.revertchance", (Object[])new Object[0]) + " " + (k > 20 ? k : 0) + "%");
                    IBlockState iBlockState = BlockVitalized.getBulbFromState(world.func_180495_p(pos.func_177977_b()));
                    currenttip.add(I18n.func_135052_a((String)"tooltip.attaineddrops2.growing", (Object[])new Object[0]) + " " + (iBlockState == null ? I18n.func_135052_a((String)"tooltip.attaineddrops2.nothing", (Object[])new Object[0]) : ModRegistry.BULB.getPickBlock(iBlockState, null, null, null, null).func_82833_r()));
                } else if (block instanceof BlockVitalized) {
                    if (state.func_177229_b(BlockVitalized.SOIL) == SoilType.NONE) {
                        if (accessor.getPlayer().func_70093_af() || Keyboard.isKeyDown((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i())) {
                            currenttip.add(I18n.func_135052_a((String)"tooltip.attaineddrops2.enableditems", (Object[])new Object[0]));
                            String string = "";
                            for (BulbType bulbType : BulbType.values()) {
                                string = string.concat(bulbType.getDrop().func_82833_r() + ", ");
                            }
                            string = string.substring(0, string.length() - 2);
                            for (String string2 : string.split(", ")) {
                                currenttip.add(string2 + ",");
                            }
                            String string3 = currenttip.get(currenttip.size() - 1);
                            currenttip.remove(string3);
                            currenttip.add(string3.substring(0, string3.length() - 1));
                        } else {
                            currenttip.add(I18n.func_135052_a((String)"tooltip.attaineddrops2.holdshift", (Object[])new Object[]{Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()}));
                        }
                    } else if (state.func_177229_b(BlockVitalized.SOIL) != SoilType.NONE) {
                        currenttip.add(I18n.func_135052_a((String)"tooltip.attaineddrops2.enrichedwith", (Object[])new Object[]{BulbType.values()[((SoilType)((Object)state.func_177229_b(BlockVitalized.SOIL))).ordinal() - 1].getDisplayName()}));
                    }
                } else if (block instanceof BlockCreator) {
                    currenttip.add(I18n.func_135052_a((String)"tooltip.attaineddrops2.creatorcharge", (Object[])new Object[]{state.func_177229_b((IProperty)BlockCreator.CHARGE)}));
                }
            }
            return currenttip;
        }

        public List<String> getWailaHead(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            return tag;
        }
    }
}

