/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.util;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEndRod;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ParticleMessage
implements IMessage {
    private BlockPos pos;
    private byte type = 0;
    private EnumDyeColor color;

    public ParticleMessage() {
    }

    public ParticleMessage(EnumDyeColor color, BlockPos pos) {
        this.pos = pos;
        this.color = color;
    }

    public ParticleMessage(EnumDyeColor color, BlockPos pos, int i) {
        this(color, pos);
        this.type = (byte)i;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.type = buf.readByte();
        this.color = EnumDyeColor.func_176764_b((int)buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeByte((int)this.type);
        buf.writeInt(this.color.func_176765_a());
    }

    public static class ParticleMessageHandler
    implements IMessageHandler<ParticleMessage, IMessage> {
        public IMessage onMessage(ParticleMessage message, MessageContext ctx) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.doMessage(message, ctx);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void doMessage(ParticleMessage message, MessageContext ctx) {
            BlockPos pos = message.pos;
            byte type = message.type;
            if (type == 0) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    int k = 0;
                    while (k < 30) {
                        double j = 0.8 - MathHelper.func_151237_a((double)(0.5 / (double)(++k)), (double)0.0, (double)0.7);
                        ParticleEndRod p = new ParticleEndRod((World)Minecraft.func_71410_x().field_71441_e, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 5.0, (double)pos.func_177952_p() + 0.5, 0.0, -j, 0.0);
                        p.func_187146_c(message.color.func_193350_e());
                        p.func_187145_d(message.color.func_193350_e());
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
                    }
                });
            } else if (type == 1) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    for (int k = 0; k < 10; ++k) {
                        double j = 0.05;
                        Random rand = Minecraft.func_71410_x().field_71441_e.field_73012_v;
                        ParticleEndRod p = new ParticleEndRod((World)Minecraft.func_71410_x().field_71441_e, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, MathHelper.func_82716_a((Random)rand, (double)-0.1, (double)0.1), j, MathHelper.func_82716_a((Random)rand, (double)-0.1, (double)0.1));
                        p.func_187146_c(message.color.func_193350_e());
                        p.func_187145_d(message.color.func_193350_e());
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
                    }
                });
            } else if (type == 2) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    int k = 0;
                    while (k < 30) {
                        double j = 0.5 - 0.01 * (double)k++;
                        Random rand = Minecraft.func_71410_x().field_71441_e.field_73012_v;
                        ParticleEndRod p = new ParticleEndRod((World)Minecraft.func_71410_x().field_71441_e, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + rand.nextDouble(), 0.0, j, 0.0);
                        p.func_187146_c(message.color.func_193350_e());
                        p.func_187145_d(message.color.func_193350_e());
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
                    }
                });
            }
        }
    }
}

