/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained;

import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.attained.AttainedConfig;
import shadows.attained.AttainedRegistry;
import shadows.attained.api.PlantingRegistry;
import shadows.attained.util.ParticleMessage;
import shadows.placebo.recipe.RecipeHelper;
import shadows.placebo.util.NetworkUtils;

@Mod(value="attained_drops")
public class AttainedDrops {
    public static final String MODID = "attained_drops";
    public static final Logger LOGGER = LogManager.getLogger((String)"attained_drops");
    public static final ItemGroup GROUP = new ItemGroup("attained_drops"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)AttainedRegistry.SEED);
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            items.add((Object)new ItemStack((IItemProvider)AttainedRegistry.SEED));
            items.add((Object)new ItemStack((IItemProvider)AttainedRegistry.LIFE_ESSENCE));
            items.add((Object)new ItemStack((IItemProvider)AttainedRegistry.VITALITY_SPREADER));
            PlantingRegistry.SOILS.values().forEach(b -> items.add((Object)new ItemStack((IItemProvider)b)));
            PlantingRegistry.BULBS.values().forEach(b -> items.add((Object)new ItemStack((IItemProvider)b)));
        }
    };
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("attained_drops", "channel")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    public static final RecipeHelper RECIPES = new RecipeHelper("attained_drops");

    public AttainedDrops() throws Exception {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AttainedConfig.spec);
        FMLJavaModLoadingContext.get().getModEventBus().register(AttainedConfig.class);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new AttainedRegistry());
        NetworkUtils.registerMessage((SimpleChannel)CHANNEL, (int)0, (NetworkUtils.MessageProvider)new ParticleMessage());
        AttainedRegistry.initRecipes();
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        if (event.getEntity() instanceof IMob && event.getSource().func_76346_g() instanceof PlayerEntity && event.getEntity().field_70170_p.field_73012_v.nextInt(Math.max((Integer)AttainedConfig.INSTANCE.dropChance.get() - event.getLootingLevel(), 1)) == 0) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, new ItemStack((IItemProvider)AttainedRegistry.LIFE_ESSENCE)));
        }
    }
}

