/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shadows.attained.api.IAttainedType;
import shadows.attained.api.ITypedBlock;
import shadows.attained.api.PlantingRegistry;
import shadows.attained.blocks.CustomBulbType;
import shadows.attained.blocks.DefaultTypes;

public class BlockSoil
extends Block
implements ITypedBlock {
    public static final Block.Properties PROPS = Block.Properties.func_200945_a((Material)Material.field_151578_c).func_200947_a(SoundType.field_185849_b).func_200948_a(0.7f, 4.0f);
    public final IAttainedType type;

    public BlockSoil(IAttainedType type) {
        super(PROPS);
        this.setRegistryName("attained_drops", type.name().toLowerCase(Locale.ROOT) + "_soil");
        this.type = type;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult res) {
        ItemStack stack = player.func_184586_b(hand);
        IAttainedType type = PlantingRegistry.byStack(stack);
        if (type != null && this.type == DefaultTypes.NONE) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, PlantingRegistry.SOILS.get(type).func_176223_P());
                world.func_184133_a(player, pos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.5f, 1.0f);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        if (hand == Hand.MAIN_HAND && stack.func_190926_b() && world.field_72995_K) {
            if (this.type == DefaultTypes.NONE) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("phrase.attained_drops.blank", new Object[0]));
                return true;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("phrase.attained_drops.vitalized", new Object[]{this.type.getDrop().func_200301_q()}));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader world, List<ITextComponent> list, ITooltipFlag flag) {
        if (this.type == DefaultTypes.NONE) {
            list.add((ITextComponent)new TranslationTextComponent("tooltip.attained_drops.unenriched", new Object[0]));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("tooltip.attained_drops.enrichedwith", new Object[]{this.type.getDrop().func_200301_q()}));
        }
    }

    public String func_149739_a() {
        if (this.type == DefaultTypes.NONE) {
            return "block.attained_drops.soil";
        }
        return "block.attained_drops.enriched.soil";
    }

    @Override
    public int getColor() {
        return this.type.getColor();
    }

    public boolean isCustom() {
        return this.type instanceof CustomBulbType;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

