/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import shadows.attained.AttainedConfig;
import shadows.attained.AttainedDrops;
import shadows.attained.api.PlantingRegistry;
import shadows.attained.blocks.DefaultTypes;
import shadows.attained.util.ParticleMessage;
import shadows.placebo.util.NetworkUtils;

public class BlockVitalitySpreader
extends Block {
    public static final IntegerProperty CHARGE = IntegerProperty.func_177719_a((String)"charge", (int)0, (int)15);
    public static final Block.Properties PROPS = Block.Properties.func_200945_a((Material)Material.field_151578_c).func_200948_a(0.5f, 12.0f).func_200947_a(SoundType.field_185849_b).func_200944_c();

    public BlockVitalitySpreader() {
        super(PROPS);
        this.setRegistryName("attained_drops", "vitality_spreader");
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)CHARGE, (Comparable)Integer.valueOf(15)));
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)CHARGE, (Comparable)Integer.valueOf(15 - ctx.func_195996_i().func_77952_i()));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder ctx) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack s = new ItemStack((IItemProvider)this);
        s.func_196085_b(15 - (Integer)state.func_177229_b((IProperty)CHARGE));
        drops.add(s);
        return drops;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(20 - (Integer)state.func_177229_b((IProperty)CHARGE)) == 0) {
            for (int i = 0; i < rand.nextInt(9); ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.02, (double)pos.func_177952_p() + 0.5, MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05), 0.06, MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05));
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{CHARGE});
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random rand) {
        if (!world.field_72995_K) {
            this.genNewSoil(world, pos, state, rand);
            ((ServerWorld)world).func_205220_G_().func_205360_a(pos, (Object)this, 40);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!world.field_72995_K) {
            ((ServerWorld)world).func_205220_G_().func_205360_a(pos, (Object)this, 40);
        }
    }

    private void genNewSoil(World world, BlockPos pos, BlockState state, Random rand) {
        int radius = (Integer)AttainedConfig.INSTANCE.spreaderRadius.get();
        BlockPos pos2 = pos.func_177982_a(MathHelper.func_76136_a((Random)rand, (int)(radius * -1), (int)radius), 0, MathHelper.func_76136_a((Random)rand, (int)(radius * -1), (int)radius));
        if (world.func_180495_p(pos2).func_177230_c().canSustainPlant(world.func_180495_p(pos2), (IBlockReader)world, pos2, Direction.UP, (IPlantable)Blocks.field_196605_bc)) {
            world.func_175656_a(pos2, PlantingRegistry.SOILS.get(DefaultTypes.NONE).func_176223_P());
            if (rand.nextBoolean()) {
                if ((Integer)state.func_177229_b((IProperty)CHARGE) == 0) {
                    world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P());
                    NetworkUtils.sendToTracking((SimpleChannel)AttainedDrops.CHANNEL, (Object)((Object)new ParticleMessage(pos.func_177984_a(), DyeColor.RED.field_193351_w, 2)), (ServerWorld)((ServerWorld)world), (BlockPos)pos);
                } else {
                    world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)CHARGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)CHARGE) - 1)));
                }
            }
            NetworkUtils.sendToTracking((SimpleChannel)AttainedDrops.CHANNEL, (Object)((Object)new ParticleMessage(pos2, DyeColor.GREEN.field_193351_w)), (ServerWorld)((ServerWorld)world), (BlockPos)pos);
        }
    }
}

