/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EndRodParticle;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shadows.attained.AttainedConfig;
import shadows.attained.api.IAttainedType;
import shadows.attained.api.ITypedBlock;
import shadows.attained.blocks.CustomBulbType;

public class BlockBulb
extends BushBlock
implements ITypedBlock {
    public static final VoxelShape SHAPE = BlockBulb.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    public static final Block.Properties PROPS = Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c).func_200948_a(0.4f, 0.0f);
    protected final IAttainedType type;

    public BlockBulb(IAttainedType type) {
        super(PROPS);
        this.setRegistryName("attained_drops", type.name().toLowerCase(Locale.ROOT) + "_bulb");
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextFloat() >= 0.6937f) {
            int color = this.type.getColor();
            EndRodParticle p = (EndRodParticle)Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)ParticleTypes.field_197624_q, (double)pos.func_177958_n() + 1.0 - rand.nextDouble(), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 1.0 - rand.nextDouble(), 0.0, 0.03, 0.0);
            p.func_187146_c(color);
            p.func_187145_d(color);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder ctx) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack harvester = (ItemStack)ctx.func_216019_b(LootParameters.field_216289_i);
        if (harvester.func_77973_b() == Items.field_151097_aZ || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)harvester) > 0) {
            drops.add(new ItemStack((IItemProvider)this));
            return drops;
        }
        ItemStack drop = this.type.getDrop().func_77946_l();
        drops.add(drop);
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)harvester);
        if (fortune > 0 && this.RANDOM.nextInt(Math.max(1, 4 - fortune)) == 0) {
            drops.add(drop.func_77946_l());
        }
        return drops;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        if (!((Boolean)AttainedConfig.INSTANCE.rightClickFarm.get()).booleanValue()) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            ItemStack drop = this.type.getDrop().func_77946_l();
            if (!player.func_191521_c(drop)) {
                BlockBulb.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177977_b());
    }

    @Override
    public int getColor() {
        return this.type.getColor();
    }

    public ITextComponent func_200291_n() {
        if (this.isCustom()) {
            return new TranslationTextComponent("block.attained_drops.custom_bulb", new Object[]{this.type.getDrop().func_200301_q()});
        }
        return new TranslationTextComponent(this.func_149739_a(), new Object[0]);
    }

    public boolean isCustom() {
        return this.type instanceof CustomBulbType;
    }
}

