/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import shadows.attained.AttainedConfig;
import shadows.attained.AttainedDrops;
import shadows.attained.AttainedRegistry;
import shadows.attained.api.PlantingRegistry;
import shadows.attained.blocks.BlockBulb;
import shadows.attained.blocks.BlockSoil;
import shadows.attained.blocks.DefaultTypes;
import shadows.attained.util.ParticleMessage;
import shadows.placebo.util.NetworkUtils;

public class BlockPlant
extends BushBlock
implements IGrowable {
    public static final IntegerProperty AGE = CropsBlock.field_176488_a;
    public static final IntegerProperty BULBS = IntegerProperty.func_177719_a((String)"bulbs", (int)0, (int)4);
    public static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)};
    public static final Block.Properties PROPS = Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200948_a(0.2f, 0.0f).func_200947_a(SoundType.field_185850_c).func_200944_c();

    public BlockPlant() {
        super(PROPS);
        this.setRegistryName("attained_drops", "plant");
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)BULBS, (Comparable)Integer.valueOf(0)));
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c() instanceof BlockSoil;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return (Boolean)AttainedConfig.INSTANCE.allowBonemeal.get();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder ctx) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if ((double)ThreadLocalRandom.current().nextFloat() >= 0.3) {
            drops.add(new ItemStack((IItemProvider)AttainedRegistry.SEED));
        }
        return drops;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean bool) {
        int age = this.getAge(world.func_180495_p(pos));
        return age < this.getMaxAge() || age == this.getMaxAge() && world.func_180495_p(pos.func_177984_a()).isAir(world, pos.func_177984_a());
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        if (world.field_72995_K) {
            return;
        }
        int age = this.getAge(state);
        if (age < this.getMaxAge()) {
            this.setAge((World)world, pos, this.getAge(state) + 1);
            return;
        }
        Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (down instanceof BlockSoil && this.isMaxAge(state) && world.func_175623_d(pos.func_177984_a())) {
            BlockBulb place = PlantingRegistry.BULBS.get(((BlockSoil)down).type);
            if (place == null) {
                return;
            }
            NetworkUtils.sendToTracking((SimpleChannel)AttainedDrops.CHANNEL, (Object)((Object)new ParticleMessage(pos.func_177984_a(), place.type.getColor(), 1)), (ServerWorld)world, (BlockPos)pos);
            world.func_175656_a(pos.func_177984_a(), place.func_176223_P());
            int bulbsGrown = (Integer)state.func_177229_b((IProperty)BULBS);
            if (bulbsGrown > 0 && rand.nextInt(5 - bulbsGrown) == 0) {
                world.func_175656_a(pos.func_177977_b(), ((Boolean)AttainedConfig.INSTANCE.revertToDirt.get() != false ? Blocks.field_150346_d : (Block)PlantingRegistry.SOILS.get(DefaultTypes.NONE)).func_176223_P());
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BULBS, (Comparable)Integer.valueOf(0)));
                NetworkUtils.sendToTracking((SimpleChannel)AttainedDrops.CHANNEL, (Object)((Object)new ParticleMessage(pos.func_177984_a(), DyeColor.RED.field_193351_w, 2)), (ServerWorld)world, (BlockPos)pos);
            } else {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BULBS, (Comparable)Integer.valueOf(bulbsGrown + 1)));
            }
        }
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (down instanceof BlockSoil && PlantingRegistry.BULBS.get(((BlockSoil)down).type) == null) {
            return down.func_225533_a_(down.func_176223_P(), world, pos.func_177977_b(), player, handIn, hit);
        }
        return ActionResultType.PASS;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.field_73012_v.nextInt(10) == 0 && this.func_176473_a((IBlockReader)world, pos, state, true)) {
            this.func_225535_a_(world, world.field_73012_v, pos, state);
        } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof SnowyDirtBlock && (Integer)state.func_177229_b((IProperty)AGE) > 0) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)AGE) - 1)));
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)AttainedRegistry.SEED);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE}).func_206894_a(new IProperty[]{BULBS});
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    private void setAge(World world, BlockPos pos, int age) {
        world.func_180501_a(pos, this.withAge(age), 2);
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return ((Integer)state.func_177229_b((IProperty)AGE)).intValue() == this.getMaxAge();
    }
}

