/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.integration;

import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import shadows.attained.AttainedRegistry;
import shadows.attained.api.IAttainedType;
import shadows.attained.api.PlantingRegistry;

public class AttainedCategory
implements IRecipeCategory<IAttainedType> {
    public static final ResourceLocation UID = new ResourceLocation("attained_drops", "fletching");
    public static final ResourceLocation TEXTURES = new ResourceLocation("attained_drops", "textures/gui/jei_screen.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;

    public AttainedCategory(IGuiHelper guiHelper) {
        ResourceLocation location = TEXTURES;
        this.background = guiHelper.createDrawable(location, 0, 0, 98, 54);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)AttainedRegistry.SEED));
        this.localizedName = Translator.translateToLocal((String)"attained_drops.growing");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<IAttainedType> getRecipeClass() {
        return IAttainedType.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void setIngredients(IAttainedType recipe, IIngredients ing) {
        ing.setOutputs(VanillaTypes.ITEM, Arrays.asList(new ItemStack((IItemProvider)PlantingRegistry.BULBS.get(recipe)), recipe.getDrop()));
        ing.setInput(VanillaTypes.ITEM, (Object)recipe.getDrop());
    }

    public void setRecipe(IRecipeLayout layout, IAttainedType recipe, IIngredients ing) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        stacks.init(0, false, 76, 18);
        stacks.init(1, true, 0, 18);
        stacks.set(ing);
    }
}

