/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.integration;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import shadows.attained.AttainedRegistry;
import shadows.attained.api.PlantingRegistry;
import shadows.attained.blocks.BlockBulb;
import shadows.attained.blocks.BlockPlant;
import shadows.attained.blocks.BlockSoil;
import shadows.attained.blocks.BlockVitalitySpreader;
import shadows.attained.blocks.DefaultTypes;

@WailaPlugin
public class HwylaPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((IComponentProvider)new PlantProvider(), TooltipPosition.BODY, BlockPlant.class);
        registrar.registerComponentProvider((IComponentProvider)new SoilProvider(), TooltipPosition.BODY, BlockSoil.class);
        registrar.registerComponentProvider((IComponentProvider)new SpreaderProvider(), TooltipPosition.BODY, BlockVitalitySpreader.class);
        registrar.registerComponentProvider((IComponentProvider)new BulbProvider(), TooltipPosition.HEAD, BlockBulb.class);
    }

    public static class BulbProvider
    implements IComponentProvider {
        public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            tooltip.clear();
            tooltip.add((ITextComponent)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getBlockName(), accessor.getStack().func_200301_q().func_150254_d())));
        }
    }

    public static class SpreaderProvider
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> currenttip, IDataAccessor accessor, IPluginConfig config) {
            if (accessor.getBlock() != null) {
                BlockPos pos = accessor.getPosition();
                World world = accessor.getWorld();
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof BlockVitalitySpreader) {
                    currenttip.add((ITextComponent)new TranslationTextComponent("tooltip.attained_drops.creatorcharge", new Object[]{state.func_177229_b((IProperty)BlockVitalitySpreader.CHARGE)}));
                }
            }
        }
    }

    public static class SoilProvider
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> currenttip, IDataAccessor accessor, IPluginConfig config) {
            if (accessor.getBlock() != null) {
                BlockPos pos = accessor.getPosition();
                World world = accessor.getWorld();
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof BlockSoil && ((BlockSoil)block).type != DefaultTypes.NONE) {
                    currenttip.add((ITextComponent)new TranslationTextComponent("tooltip.attained_drops.enrichedwith", new Object[]{((BlockSoil)block).type.getDrop().func_200301_q()}));
                }
            }
        }
    }

    public static class PlantProvider
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> currenttip, IDataAccessor accessor, IPluginConfig config) {
            if (accessor.getBlock() != null) {
                BlockPos pos = accessor.getPosition();
                World world = accessor.getWorld();
                BlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof BlockPlant) {
                    currenttip.add((ITextComponent)new TranslationTextComponent("tooltip.attained_drops.growth", new Object[]{(int)(100.0f * ((float)((Integer)state.func_177229_b((IProperty)BlockPlant.AGE)).intValue() / (float)AttainedRegistry.PLANT.getMaxAge())) + "%"}));
                    BlockState down = world.func_180495_p(pos.func_177977_b());
                    if (down.func_177230_c() instanceof BlockSoil) {
                        BlockBulb bulb = PlantingRegistry.BULBS.get(((BlockSoil)down.func_177230_c()).type);
                        if (bulb == null) {
                            return;
                        }
                        ITextComponent name = bulb.func_200291_n();
                        currenttip.add((ITextComponent)new TranslationTextComponent("tooltip.attained_drops.growing", new Object[]{name}));
                    }
                }
            }
        }
    }
}

