/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.attained.api.IBulb;
import shadows.attained.blocks.BlockPlant;
import shadows.attained.init.ModRegistry;
import shadows.attained.util.AD2Util;

public class BlockBulbBase
extends Block
implements IBulb {
    private TextFormatting textColor;

    public BlockBulbBase(String name) {
        this("", name);
    }

    public BlockBulbBase(String modid, String name) {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.setRegistryName(name + "_bulb");
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149663_c((modid.isEmpty() ? "attaineddrops" : modid) + ".bulb." + name);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    public int getDamageValue(World world, int x, int y, int z) {
        return this.func_176201_c(world.func_180495_p(new BlockPos(x, y, z)));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.5, 0.6875);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int quantityDropped(IBlockState state, int fortune, @Nonnull Random random) {
        return this.func_149679_a(fortune, random);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149679_a(int fortune, @Nonnull Random rand) {
        int j = rand.nextInt(fortune + 1);
        return j + 1;
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && !world.func_175623_d(pos.func_177979_c(1));
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
        ItemStack drop = AD2Util.getBulbDrop(this);
        int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        drop.field_77994_a = this.quantityDropped(state, fortuneLevel, world.field_73012_v);
        EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, drop);
        entityitem.func_174869_p();
        world.func_72838_d((Entity)entityitem);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        Block block2Below;
        if (world.func_180495_p(pos.func_177977_b()) != null && world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModRegistry.BLOCK_PLANT && AD2Util.isSoil(block2Below = world.func_180495_p(pos.func_177967_a(EnumFacing.DOWN, 2)).func_177230_c()) && AD2Util.isSoilEnriched(AD2Util.getSoilFromBlock(block2Below))) {
            world.func_180501_a(pos.func_177977_b(), ((BlockPlant)world.func_180495_p(pos.func_177977_b()).func_177230_c()).func_176203_a(7), 2);
            return;
        }
        world.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 3);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        super.func_189540_a(state, worldIn, pos, blockIn);
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != ModRegistry.BLOCK_PLANT) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public int func_149738_a(World world) {
        return 90;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void setTextColor(TextFormatting color) {
        if (color.func_96302_c()) {
            this.textColor = color;
            return;
        }
        this.textColor = TextFormatting.GRAY;
    }

    @Override
    public TextFormatting getTextColor() {
        return this.textColor;
    }
}

