/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.attained.api.IBulb;
import shadows.attained.api.ITOPInfoProvider;
import shadows.attained.api.IVitalizedSoil;
import shadows.attained.init.ModConfig;
import shadows.attained.init.ModNetworkHandler;
import shadows.attained.init.ModRegistry;
import shadows.attained.network.PacketSpawnParticle;
import shadows.attained.util.AD2Util;

public class BlockPlant
extends BlockBush
implements IGrowable,
ITOPInfoProvider {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.125, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.25, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.375, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.5, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.625, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.75, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.875, 0.84375), new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 1.0, 0.84375)};

    public BlockPlant() {
        this.setRegistryName("plant");
        this.func_149663_c("attaineddrops.blockplant");
        this.func_149711_c(0.2f);
        this.func_149647_a(ModRegistry.AD2_TAB);
        this.func_149672_a(SoundType.field_185850_c);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public int func_149738_a(World world) {
        return 1;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return ModConfig.ConfigOptions.CAN_BONEMEAL;
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        List ret = super.getDrops(world, pos, state, fortune);
        ret.clear();
        if (Math.random() >= 0.3) {
            ret.add(new ItemStack((Item)ModRegistry.ITEM_SEED));
        }
        return ret;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180645_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        this.func_180650_b(worldIn, pos, state, random);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return AD2Util.isSoil(world.func_180495_p(pos.func_177977_b()).func_177230_c());
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean bool) {
        if (AD2Util.isSoil(world.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            int age = this.getAge(world.func_180495_p(pos));
            if (age < this.getMaxAge()) {
                return true;
            }
            if (age == this.getMaxAge() && world.func_175623_d(pos.func_177984_a())) {
                return true;
            }
        }
        return false;
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (AD2Util.isSoil(world.func_180495_p(pos.func_177977_b()).func_177230_c())) {
            if (this.getAge(state) < this.getMaxAge() && rand.nextInt(3) == 0) {
                this.setAge(world, pos, this.getAge(state) + 1);
            }
            if (this.getAge(state) == this.getMaxAge() && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof IVitalizedSoil) {
                IVitalizedSoil soil = (IVitalizedSoil)world.func_180495_p(pos.func_177977_b()).func_177230_c();
                IBulb bulb = AD2Util.getBulbFromSoil(soil);
                if (world.func_175623_d(pos.func_177984_a()) && AD2Util.isSoilEnriched(soil) && world.field_73012_v.nextInt(8) == 5) {
                    world.func_180501_a(pos.func_177984_a(), AD2Util.getBulbState(bulb), 2);
                }
            }
        }
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        int meta = this.getAge(world.func_180495_p(pos));
        Block downBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (AD2Util.isSoil(downBlock) && AD2Util.isSoilEnriched(AD2Util.getSoilFromBlock(downBlock))) {
            if (meta < 7 && rand.nextInt(5) == 0) {
                this.setAge(world, pos, ++meta);
                ModNetworkHandler.getInstance().sendToAllAround((IMessage)new PacketSpawnParticle(EnumParticleTypes.VILLAGER_HAPPY.func_179348_c(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 4, (double)meta / 100.0), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0));
            }
            if (meta == 7 && rand.nextInt(5) == 0 && world.func_175623_d(pos.func_177984_a())) {
                ModNetworkHandler.getInstance().sendToAllAround((IMessage)new PacketSpawnParticle(EnumParticleTypes.VILLAGER_HAPPY.func_179348_c(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 4, 0.5), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0));
                world.func_180501_a(pos.func_177984_a(), AD2Util.getBulbState(AD2Util.getBulbFromSoil(AD2Util.getSoilFromBlock(downBlock))), 2);
                if (rand.nextInt(15) == 0) {
                    world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 2);
                }
            }
            return;
        }
    }

    protected boolean func_185514_i(IBlockState state) {
        return AD2Util.isSoil(state.func_177230_c());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public int getMaxAge() {
        return 7;
    }

    public int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    private void setAge(World world, BlockPos pos, int age) {
        world.func_180501_a(pos, this.withAge(age), 2);
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) >= this.getMaxAge();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        IBulb bulb = AD2Util.getBulbFromPlant(world, data.getPos());
        probeInfo.horizontal().text("     Type: " + bulb.getTextColor() + "" + AD2Util.getBulbDrop(bulb).func_82833_r());
        probeInfo.horizontal().text("     Growth: " + AD2Util.getPlantGrowthPercent(blockState) + "%");
    }
}

