/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import shadows.attained.api.IBulb;
import shadows.attained.api.ITOPInfoProvider;
import shadows.attained.api.IVitalizedSoil;
import shadows.attained.init.ModRegistry;
import shadows.attained.util.AD2Util;

public class BlockVitalizedBase
extends Block
implements IVitalizedSoil,
ITOPInfoProvider {
    private final String modid;

    public BlockVitalizedBase(String name) {
        this("", name);
    }

    public BlockVitalizedBase(String modid, String name) {
        super(Material.field_151578_c);
        this.setRegistryName(name + "_soil");
        this.func_149711_c(0.8f);
        this.func_149647_a(ModRegistry.AD2_TAB);
        this.func_149672_a(SoundType.field_185849_b);
        this.modid = modid.isEmpty() ? "attaineddrops" : modid;
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (!world.field_72995_K) {
            if (heldItem != null && this.canPlayerEnrich(player, state)) {
                world.func_180501_a(pos, AD2Util.getBlockFromSoil(AD2Util.getSoilFromItem(heldItem)).func_176223_P(), 2);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 0.6f, 0.8f);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                }
                return true;
            }
        } else if (player.field_71071_by.func_70448_g() == null) {
            if (this.getBulb() != null) {
                player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"phrase.attaineddrops.dirtstart", (Object[])new Object[0]) + this.getBulb().getTextColor() + " " + AD2Util.getBulbDrop(this.getBulb()).func_82833_r()));
            } else {
                player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"phrase.attaineddrops.dirtblank", (Object[])new Object[0])));
            }
        }
        return false;
    }

    private IBulb getBulb() {
        return AD2Util.getBulbFromSoil(this);
    }

    private boolean canPlayerEnrich(EntityPlayer player, IBlockState state) {
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        return currentItem != null && AD2Util.isItemApplicable(currentItem) && !AD2Util.isSoilEnriched(AD2Util.getSoilFromBlock(state.func_177230_c()));
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean useExtraInformation) {
        if (!AD2Util.isSoilEnriched(this)) {
            if (player.func_70093_af() || Keyboard.isKeyDown((int)AD2Util.getSneakKey().func_151463_i())) {
                AD2Util.generateList(list);
            } else {
                list.add(AD2Util.getSneakString());
            }
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.attaineddrops.enrichedwith", (Object[])new Object[]{this.getBulb().getTextColor() + AD2Util.getBulbDrop(this.getBulb()).func_82833_r() + TextFormatting.GRAY}));
        }
    }

    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(Blocks.field_150346_d));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public String func_149739_a() {
        return "tile." + this.modid + ".vitalized." + (!AD2Util.isSoilEnriched(this) ? "base" : "enriched");
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        IBulb bulb = AD2Util.getBulbFromSoil(this);
        if (!AD2Util.isSoilEnriched(this)) {
            if (player.func_70093_af() || Keyboard.isKeyDown((int)AD2Util.getSneakKey().func_151463_i())) {
                List<String> nameList = AD2Util.getApplicableItemNames();
                probeInfo.horizontal(new LayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(I18n.func_135052_a((String)"tooltip.attaineddrops.enableditems", (Object[])new Object[]{TextFormatting.ITALIC + "" + TextFormatting.UNDERLINE}));
                for (String line : nameList) {
                    probeInfo.horizontal().text(line);
                }
            } else {
                probeInfo.horizontal().text(AD2Util.getSneakString());
            }
        } else {
            probeInfo.horizontal().text("     Type: " + bulb.getTextColor() + "" + AD2Util.getBulbDrop(bulb).func_82833_r());
        }
    }
}

