/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.integration;

import com.google.common.collect.Lists;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import shadows.attained.api.IBulb;
import shadows.attained.api.IVitalizedSoil;
import shadows.attained.blocks.BlockBulb;
import shadows.attained.blocks.BlockPlant;
import shadows.attained.blocks.BlockVitalized;
import shadows.attained.util.AD2Util;

public class WAILA {
    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerStackProvider((IWailaDataProvider)new Provider(), BlockPlant.class);
        registrar.registerBodyProvider((IWailaDataProvider)new Provider(), BlockPlant.class);
        registrar.registerBodyProvider((IWailaDataProvider)new Provider(), BlockVitalized.class);
        registrar.registerHeadProvider((IWailaDataProvider)new Provider(), BlockPlant.class);
        registrar.registerHeadProvider((IWailaDataProvider)new Provider(), BlockBulb.class);
        registrar.registerHeadProvider((IWailaDataProvider)new Provider(), BlockVitalized.class);
    }

    public static class Provider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (accessor.getBlock() != null) {
                BlockPos pos = accessor.getPosition();
                World world = accessor.getWorld();
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (AD2Util.isPlant(block) && AD2Util.getBulbFromPlant(world, pos) != null) {
                    return new ItemStack(AD2Util.getBlockFromBulb(AD2Util.getBulbFromPlant(world, pos)));
                }
            }
            return null;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            currenttip = Lists.newArrayList();
            if (accessor.getBlock() != null) {
                BlockPos pos = accessor.getPosition();
                World world = accessor.getWorld();
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (AD2Util.isPlant(block)) {
                    if (AD2Util.getBulbFromPlant(world, pos) != null) {
                        IBulb bulb = AD2Util.getBulbFromPlant(world, pos);
                        currenttip.add(bulb.getTextColor() + "" + AD2Util.getBulbDrop(bulb).func_82833_r() + " Plant");
                    }
                } else if (AD2Util.isBulb(block)) {
                    IBulb bulb = AD2Util.getBulbFromBlock(block);
                    currenttip.add(bulb.getTextColor() + "" + AD2Util.getBulbDrop(bulb).func_82833_r() + " Bulb");
                } else if (AD2Util.isSoil(block)) {
                    IVitalizedSoil soil = AD2Util.getSoilFromBlock(block);
                    if (AD2Util.isSoilEnriched(soil)) {
                        IBulb bulb = AD2Util.getBulbFromSoil(soil);
                        currenttip.add(bulb.getTextColor() + "" + AD2Util.getBulbDrop(bulb).func_82833_r() + " " + new ItemStack(block).func_82833_r());
                    } else {
                        currenttip.add(TextFormatting.WHITE + "" + new ItemStack(block).func_82833_r());
                    }
                }
            }
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (accessor.getBlock() != null) {
                IVitalizedSoil soil;
                BlockPos pos = accessor.getPosition();
                World world = accessor.getWorld();
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (AD2Util.isPlant(block) && AD2Util.getBulbFromPlant(world, pos) != null) {
                    currenttip.add("Growth: " + AD2Util.getPlantGrowthPercent(state) + "%");
                }
                if (AD2Util.isSoil(block) && !AD2Util.isSoilEnriched(soil = AD2Util.getSoilFromBlock(block))) {
                    if (accessor.getPlayer().func_70093_af() || Keyboard.isKeyDown((int)AD2Util.getSneakKey().func_151463_i())) {
                        AD2Util.generateList(currenttip);
                    } else {
                        currenttip.add(AD2Util.getSneakString());
                    }
                }
            }
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return null;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
            return null;
        }
    }
}

