/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.attained.init.ModConfig;
import shadows.attained.init.ModNetworkHandler;
import shadows.attained.init.ModRegistry;
import shadows.attained.network.PacketSpawnParticle;

public class BlockSoilCreator
extends Block {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);

    public BlockSoilCreator() {
        super(Material.field_151578_c);
        this.setRegistryName("soilcreator");
        this.func_149711_c(0.8f);
        this.func_149675_a(true);
        this.func_149647_a(ModRegistry.AD2_TAB);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149663_c("attaineddrops.soilcreator");
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public void func_180645_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random random) {
        this.func_180650_b(worldIn, pos, state, random);
        this.func_180650_b(worldIn, pos, state, random);
        this.func_180650_b(worldIn, pos, state, random);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        int l = this.func_176201_c(state);
        if (l < 15) {
            ++l;
            int diameter = ModConfig.getDiameter();
            int minX = (int)((double)pos.func_177958_n() - Math.ceil(diameter / 2));
            int minZ = (int)((double)pos.func_177952_p() - Math.ceil(diameter / 2));
            int maxX = minX + diameter;
            int maxZ = minZ + diameter;
            int i = rand.nextInt(maxX - minX) + minX;
            int k = rand.nextInt(maxZ - minZ) + minZ;
            if (world.func_180495_p(new BlockPos(i, pos.func_177956_o(), k)).func_177230_c() == Blocks.field_150346_d || world.func_180495_p(new BlockPos(i, pos.func_177956_o(), k)).func_177230_c() == Blocks.field_150349_c) {
                world.func_180501_a(new BlockPos(i, pos.func_177956_o(), k), ModRegistry.VITALIZED_BASE.func_176223_P(), 2);
                world.func_180501_a(pos, this.func_176203_a(l), 2);
                if (!world.field_72995_K) {
                    ModNetworkHandler.getInstance().sendToAllAround((IMessage)new PacketSpawnParticle(EnumParticleTypes.VILLAGER_HAPPY.func_179348_c(), i, pos.func_177956_o(), k, 3, 0.5), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0));
                }
            }
        }
        if (l == 15) {
            world.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

