/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.network;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import shadows.attained.AttainedDrops;

public class PacketSpawnParticle
implements IMessage {
    public EnumParticleTypes particle;
    public int x;
    public int y;
    public int z;
    public int numParticles;
    public double yLevel;

    public PacketSpawnParticle() {
    }

    public PacketSpawnParticle(int particlIndex, int posX, int posY, int posZ) {
        this(particlIndex, posX, posY, posZ, 1, 0.0);
    }

    public PacketSpawnParticle(int particlIndex, int posX, int posY, int posZ, int numParticlesIn, double yLevelIn) {
        this.particle = EnumParticleTypes.func_179342_a((int)particlIndex);
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.numParticles = numParticlesIn;
        this.yLevel = yLevelIn;
    }

    public void fromBytes(ByteBuf buf) {
        this.particle = EnumParticleTypes.func_179342_a((int)buf.readInt());
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.numParticles = buf.readInt();
        this.yLevel = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.particle.func_179348_c());
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.numParticles);
        buf.writeDouble(this.yLevel);
    }

    public static class Handler
    implements IMessageHandler<PacketSpawnParticle, IMessage> {
        public IMessage onMessage(final PacketSpawnParticle message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Handler.this.handle(message, ctx);
                }
            });
            return null;
        }

        private void handle(PacketSpawnParticle message, MessageContext ctx) {
            if (ctx.getClientHandler() != null) {
                World world = AttainedDrops.PROXY.getWorld();
                Random rand = world.field_73012_v;
                double posX = message.x;
                double posY = message.y;
                double posZ = message.z;
                for (int i = 0; i < message.numParticles; ++i) {
                    int r1 = rand.nextInt(2);
                    int r2 = rand.nextInt(2);
                    double x = posX + (r1 == 0 ? rand.nextDouble() / 10.0 : -(rand.nextDouble() / 10.0));
                    double y = posY + rand.nextDouble() + 0.5;
                    double z = posZ + (r2 == 0 ? rand.nextDouble() / 10.0 : -(rand.nextDouble() / 10.0));
                    world.func_175688_a(message.particle, x + 0.6, y + message.yLevel, z + 0.6, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }
}

