/*
 * Decompiled with CFR 0.152.
 */
package shadows.attained.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shadows.attained.api.IBulb;
import shadows.attained.api.IVitalizedSoil;
import shadows.attained.blocks.BlockPlant;
import shadows.attained.init.ModRegistry;

public class AD2Util {
    public static Map<IBulb, IVitalizedSoil> getBulbs() {
        return ModRegistry.getBulbRegistry();
    }

    public static Map<IVitalizedSoil, IBulb> getSoils() {
        return ModRegistry.getSoilRegistry();
    }

    public static Map<IBulb, ItemStack> getDrops() {
        return ModRegistry.getDropsRegistry();
    }

    public static void registerAD2(IBulb bulb, IVitalizedSoil soil, ItemStack drop) {
        AD2Util.registerBulb(bulb, soil);
        AD2Util.registerDrop(bulb, drop);
    }

    private static void registerBulb(IBulb bulb, IVitalizedSoil soil) {
        if (!AD2Util.getBulbs().containsKey(bulb)) {
            AD2Util.getBulbs().put(bulb, soil);
        }
        AD2Util.registerSoil(soil, bulb);
    }

    private static void registerSoil(IVitalizedSoil soil, IBulb bulb) {
        if (!AD2Util.getSoils().containsKey(soil)) {
            AD2Util.getSoils().put(soil, bulb);
        }
    }

    private static void registerDrop(IBulb bulb, ItemStack stack) {
        if (!AD2Util.getDrops().containsKey(bulb) && !AD2Util.getDrops().containsValue(stack)) {
            AD2Util.getDrops().put(bulb, stack);
        }
    }

    public static ItemStack getBulbDrop(IBulb bulb) {
        return AD2Util.getDrops().get(bulb);
    }

    public static List<ItemStack> getApplicableItems() {
        ArrayList result = Lists.newArrayList();
        if (AD2Util.getBulbs().size() > 0) {
            for (IBulb bulb : AD2Util.getBulbs().keySet()) {
                result.add(AD2Util.getBulbDrop(bulb));
            }
        }
        return result;
    }

    public static void generateList(List<String> list) {
        List<String> nameList = AD2Util.getApplicableItemNames();
        list.add(I18n.func_135052_a((String)"tooltip.attaineddrops.enableditems", (Object[])new Object[]{TextFormatting.ITALIC + "" + TextFormatting.UNDERLINE}));
        for (String line : nameList) {
            list.add(line);
        }
    }

    public static boolean isItemApplicable(ItemStack stackIn) {
        for (ItemStack stack : AD2Util.getApplicableItems()) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)stackIn)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlant(Block block) {
        return block instanceof BlockPlant;
    }

    public static IBulb getBulbFromPlant(World world, BlockPos pos) {
        if (AD2Util.isPlant(world.func_180495_p(pos).func_177230_c())) {
            Block downBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            Block upBlock = world.func_180495_p(pos.func_177984_a()).func_177230_c();
            if (AD2Util.isSoil(downBlock)) {
                IVitalizedSoil soil = AD2Util.getSoilFromBlock(downBlock);
                if (AD2Util.isSoilEnriched(soil)) {
                    return AD2Util.getSoils().get(soil);
                }
            } else if (AD2Util.isBulb(upBlock)) {
                IBulb bulb = AD2Util.getBulbFromBlock(upBlock);
                return bulb;
            }
        }
        return null;
    }

    public static List<String> getApplicableItemNames() {
        ArrayList nameList = Lists.newArrayList();
        for (ItemStack item : AD2Util.getApplicableItems()) {
            nameList.add(AD2Util.getBulbFromItem(item).getTextColor() + "" + item.func_82833_r());
        }
        return nameList;
    }

    public static IBulb getBulbFromItem(ItemStack stack) {
        if (AD2Util.isItemApplicable(stack)) {
            for (IBulb bulb : AD2Util.getBulbs().keySet()) {
                if (!ItemStack.func_179545_c((ItemStack)AD2Util.getBulbDrop(bulb), (ItemStack)stack)) continue;
                return bulb;
            }
        }
        return null;
    }

    public static IVitalizedSoil getSoilFromItem(ItemStack stack) {
        if (AD2Util.isItemApplicable(stack)) {
            for (IVitalizedSoil soil : AD2Util.getSoils().keySet()) {
                if (!ItemStack.func_179545_c((ItemStack)AD2Util.getBulbDrop(AD2Util.getBulbFromSoil(soil)), (ItemStack)stack)) continue;
                return soil;
            }
        }
        return null;
    }

    public static IBlockState getSoilState(IVitalizedSoil soil) {
        return AD2Util.getBlockFromSoil(soil).func_176223_P();
    }

    public static boolean isSoilEnriched(IVitalizedSoil soil) {
        return soil != AD2Util.getSoilFromBlock(ModRegistry.VITALIZED_BASE);
    }

    public static Block getBlockFromSoil(IVitalizedSoil soil) {
        return (Block)soil;
    }

    public static IBlockState getBulbState(IBulb bulb) {
        return AD2Util.getBlockFromBulb(bulb).func_176223_P();
    }

    public static Block getBlockFromBulb(IBulb bulb) {
        return (Block)bulb;
    }

    public static IBulb getBulbFromSoil(IVitalizedSoil soil) {
        return AD2Util.getSoils().get(soil);
    }

    public static boolean isSoil(Block block) {
        return block instanceof IVitalizedSoil;
    }

    public static boolean isBulb(Block block) {
        return block instanceof IBulb;
    }

    public static IBulb getBulbFromBlock(Block block) {
        return AD2Util.isBulb(block) ? (IBulb)block : null;
    }

    public static IVitalizedSoil getSoilFromBlock(Block block) {
        return AD2Util.isSoil(block) ? (IVitalizedSoil)block : null;
    }

    public static BlockPlant getPlantFromBlock(Block block) {
        return AD2Util.isPlant(block) ? (BlockPlant)block : null;
    }

    public static int getPlantGrowthPercent(IBlockState state) {
        float percent = 0.0f;
        if (AD2Util.isPlant(state.func_177230_c())) {
            BlockPlant plant = AD2Util.getPlantFromBlock(state.func_177230_c());
            int currentAge = plant.getAge(state);
            int maxAge = plant.getMaxAge();
            percent = Math.round(currentAge * 100 / maxAge);
        }
        return (int)percent;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getSneakString() {
        KeyBinding sneak = AD2Util.getSneakKey();
        return I18n.func_135052_a((String)"tooltip.attaineddrops.holdshift", (Object[])new Object[]{sneak.getDisplayName()});
    }

    @SideOnly(value=Side.CLIENT)
    public static KeyBinding getSneakKey() {
        return Minecraft.func_71410_x().field_71474_y.field_74311_E;
    }

    public static boolean getMod(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public static ItemStack getSoilStack(IVitalizedSoil soil) {
        return new ItemStack(AD2Util.getBlockFromSoil(soil));
    }

    public static ItemStack getBulbStack(IBulb bulb) {
        return new ItemStack(AD2Util.getBlockFromBulb(bulb));
    }
}

