/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import paulevs.betternether.config.Config;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.structures.IStructure;
import paulevs.betternether.structures.StructureType;
import paulevs.betternether.structures.StructureWorld;
import paulevs.betternether.structures.plants.StructureWartCap;

public class NetherBiome {
    private static final OpenSimplexNoise SCATTER = new OpenSimplexNoise(1337L);
    private static int structureID = 0;
    private ArrayList<StructureInfo> generatorsFloor = new ArrayList();
    private ArrayList<StructureInfo> generatorsWall = new ArrayList();
    private ArrayList<StructureInfo> generatorsCeil = new ArrayList();
    private ArrayList<StructureInfo> generatorsLava = new ArrayList();
    private ArrayList<StructureInfo> buildGeneratorsFloor = new ArrayList();
    private ArrayList<StructureInfo> buildGeneratorsCeil = new ArrayList();
    private ArrayList<StructureInfo> buildGeneratorsLava = new ArrayList();
    private ArrayList<StructureInfo> buildGeneratorsUnder = new ArrayList();
    protected String name;
    protected NetherBiome edge;
    protected int edgeSize;
    protected List<Subbiome> subbiomes;
    protected NetherBiome parrent;
    protected float maxSubBiomeChance = 1.0f;
    protected float genChance = 1.0f;
    protected float noiseDensity = 0.3f;
    private static final String[] DEF_STRUCTURES = new String[]{NetherBiome.structureFormat("altar_01", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_02", -4, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_03", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_04", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_05", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_06", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_07", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_08", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("portal_01", -4, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("portal_02", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("garden_01", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("garden_02", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_01", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_02", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_03", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_04", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_05", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_06", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_01", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_02", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_03", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_04", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("spawn_altar_ladder", -5, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("ghast_hive", -20, StructureType.CEIL, 1.0f)};
    private ArrayList<String> structures;

    public NetherBiome(String name) {
        this.name = name;
        this.subbiomes = new ArrayList<Subbiome>();
        this.addStructure("cap_gen", new StructureWartCap(), StructureType.WALL, 0.8f, true);
        this.subbiomes.add(new Subbiome(this, 1.0f));
        this.structures = new ArrayList(DEF_STRUCTURES.length);
        for (String s : DEF_STRUCTURES) {
            this.structures.add(s);
        }
    }

    public void setNoiseDensity(float density) {
        this.noiseDensity = 1.0f - density * 2.0f;
    }

    public float getNoiseDensity() {
        return (1.0f - this.noiseDensity) / 2.0f;
    }

    public void build() {
        String[] structAll;
        String group = "generator_" + this.getRegistryName();
        for (String struct : structAll = Config.getStringArray(group, "structures", this.structures.toArray(new String[0]))) {
            this.structureFromString(struct);
        }
        this.setNoiseDensity(Config.getFloat(group, "noise_density", this.getNoiseDensity()));
    }

    public void genSurfColumn(class_1936 world, class_2338 pos, Random random) {
    }

    public void genFloorObjects(class_1936 world, class_2338 pos, Random random) {
        for (StructureInfo info : this.generatorsFloor) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random);
        }
    }

    public void genWallObjects(class_1936 world, class_2338 pos, Random random) {
        for (StructureInfo info : this.generatorsWall) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random);
        }
    }

    public void genCeilObjects(class_1936 world, class_2338 pos, Random random) {
        for (StructureInfo info : this.generatorsCeil) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random);
        }
    }

    public void genLavaObjects(class_1936 world, class_2338 pos, Random random) {
        for (StructureInfo info : this.generatorsLava) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random);
        }
    }

    protected static double getFeatureNoise(class_2338 pos, int id) {
        return SCATTER.eval((double)pos.method_10263() * 0.1, (double)pos.method_10264() * 0.1 + (double)(id * 10), (double)pos.method_10260() * 0.1);
    }

    public String getName() {
        return this.name;
    }

    public String getRegistryName() {
        return this.name.toLowerCase().replace(' ', '_');
    }

    public NetherBiome getEdge() {
        return this.edge;
    }

    public void setEdge(NetherBiome edge) {
        this.edge = edge;
        edge.parrent = this;
    }

    public int getEdgeSize() {
        return this.edgeSize;
    }

    public void setEdgeSize(int size) {
        this.edgeSize = size;
    }

    public void addSubBiome(NetherBiome biome, float chance) {
        this.maxSubBiomeChance += chance;
        biome.parrent = this;
        this.subbiomes.add(new Subbiome(biome, this.maxSubBiomeChance));
    }

    public NetherBiome getSubBiome(Random random) {
        float chance = random.nextFloat() * this.maxSubBiomeChance;
        for (Subbiome biome : this.subbiomes) {
            if (!biome.canGenerate(chance)) continue;
            return biome.biome;
        }
        return this;
    }

    public NetherBiome getParrentBiome() {
        return this.parrent;
    }

    public boolean hasEdge() {
        return this.edge != null;
    }

    public boolean hasParrent() {
        return this.parrent != null;
    }

    public boolean isSame(NetherBiome biome) {
        return biome == this || biome.hasParrent() && biome.getParrentBiome() == this;
    }

    protected void addStructure(String name, IStructure structure, StructureType type, float density, boolean useNoise) {
        String group = "generator_" + this.getRegistryName();
        float dens = Config.getFloat(group, name + "_density", density);
        boolean limit = Config.getBoolean(group, name + "_limit", useNoise);
        this.addStructure(structure, type, dens, limit);
    }

    private void addStructure(IStructure structure, StructureType type, float density, boolean useNoise) {
        switch (type) {
            case CEIL: {
                this.generatorsCeil.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case FLOOR: {
                this.generatorsFloor.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case WALL: {
                this.generatorsWall.add(new StructureInfo(structure, density, useNoise));
                break;
            }
        }
    }

    protected void addWorldStructures(String ... structures) {
        for (String s : structures) {
            this.structures.add(s);
        }
    }

    public boolean canGenerate(float chance) {
        return chance < this.genChance;
    }

    public void setGenChance(float chance) {
        this.genChance = chance;
    }

    protected static String structureFormat(String name, int offset, StructureType type, float chance) {
        return String.format(Locale.ROOT, "name: %s; offset: %d; type: %s; chance: %f", name, offset, type.getName(), Float.valueOf(chance));
    }

    public void genFloorBuildings(class_1936 world, class_2338 pos, Random random) {
        this.chancedStructure(world, pos, random, this.buildGeneratorsFloor);
    }

    public void genCeilBuildings(class_1936 world, class_2338 pos, Random random) {
        this.chancedStructure(world, pos, random, this.buildGeneratorsCeil);
    }

    public void genLavaBuildings(class_1936 world, class_2338 pos, Random random) {
        this.chancedStructure(world, pos, random, this.buildGeneratorsLava);
    }

    public void genUnderBuildings(class_1936 world, class_2338 pos, Random random) {
        this.chancedStructure(world, pos, random, this.buildGeneratorsUnder);
    }

    private void chancedStructure(class_1936 world, class_2338 pos, Random random, List<StructureInfo> infoList) {
        float chance = this.getLastChance(infoList);
        if (chance > 0.0f) {
            float rnd = random.nextFloat() * chance;
            for (StructureInfo info : infoList) {
                if (!(rnd <= info.density)) continue;
                info.structure.generate(world, pos, random);
                return;
            }
        }
    }

    private void structureFromString(String structureString) {
        StructureWorld structure;
        String[] args = structureString.split(";");
        String name = "";
        int offset = 0;
        StructureType type = StructureType.FLOOR;
        float chance = 0.0f;
        for (String a : args) {
            if (a.contains("name:")) {
                name = a.replace("name:", "").trim();
                continue;
            }
            if (a.contains("offset:")) {
                offset = Integer.parseInt(a.replace("offset:", "").trim());
                continue;
            }
            if (a.contains("type:")) {
                type = StructureType.fromString(a);
                continue;
            }
            if (!a.contains("chance:")) continue;
            chance = Float.parseFloat(a.replace("chance:", "").trim());
        }
        if (!name.isEmpty() && (structure = new StructureWorld(name, offset, type)).loaded()) {
            ArrayList<StructureInfo> infoList = null;
            switch (structure.getType()) {
                case CEIL: {
                    infoList = this.buildGeneratorsCeil;
                    break;
                }
                case FLOOR: {
                    infoList = this.buildGeneratorsFloor;
                    break;
                }
                case LAVA: {
                    infoList = this.buildGeneratorsLava;
                    break;
                }
                case UNDER: {
                    infoList = this.buildGeneratorsUnder;
                    break;
                }
            }
            StructureInfo info = new StructureInfo(structure, chance += this.getLastChance(infoList), false);
            infoList.add(info);
        }
    }

    private float getLastChance(List<StructureInfo> info) {
        int size = info.size();
        return size > 0 ? info.get((int)(size - 1)).density : 0.0f;
    }

    public boolean hasCeilStructures() {
        return !this.buildGeneratorsCeil.isEmpty();
    }

    protected class Subbiome {
        NetherBiome biome;
        float chance;

        Subbiome(NetherBiome biome, float chance) {
            this.biome = biome;
            this.chance = chance;
        }

        public boolean canGenerate(float chance) {
            return chance < this.chance;
        }
    }

    protected class StructureInfo {
        final IStructure structure;
        final float density;
        final boolean useNoise;
        final int id;

        StructureInfo(IStructure structure, float density, boolean useNoise) {
            this.structure = structure;
            this.density = density;
            this.useNoise = useNoise;
            this.id = structureID++;
        }

        boolean canGenerate(Random random, class_2338 pos) {
            return (!this.useNoise || NetherBiome.getFeatureNoise(pos, this.id) > (double)NetherBiome.this.noiseDensity) && random.nextFloat() < this.density;
        }
    }
}

