/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.StructureType;
import paulevs.betternether.structures.plants.StructureBlackBush;
import paulevs.betternether.structures.plants.StructureBlackVine;
import paulevs.betternether.structures.plants.StructureReeds;
import paulevs.betternether.structures.plants.StructureSmoker;
import paulevs.betternether.structures.plants.StructureSoulVein;
import paulevs.betternether.structures.plants.StructureSwampGrass;
import paulevs.betternether.structures.plants.StructureWallBrownMushroom;
import paulevs.betternether.structures.plants.StructureWallMoss;
import paulevs.betternether.structures.plants.StructureWallRedMushroom;
import paulevs.betternether.structures.plants.StructureWillow;

public class NetherSwampland
extends NetherBiome {
    public NetherSwampland(String name) {
        super(name);
        this.addStructure("willow", new StructureWillow(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("nether_reed", new StructureReeds(), StructureType.FLOOR, 0.8f, false);
        this.addStructure("soul_vein", new StructureSoulVein(), StructureType.FLOOR, 0.5f, false);
        this.addStructure("smoker", new StructureSmoker(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("black_bush", new StructureBlackBush(), StructureType.FLOOR, 0.02f, false);
        this.addStructure("nether_grass", new StructureSwampGrass(), StructureType.FLOOR, 0.4f, false);
        this.addStructure("black_vine", new StructureBlackVine(), StructureType.CEIL, 0.4f, true);
        this.addStructure("wall_moss", new StructureWallMoss(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_red_mushroom", new StructureWallRedMushroom(), StructureType.WALL, 0.8f, true);
        this.addStructure("wall_brown_mushroom", new StructureWallBrownMushroom(), StructureType.WALL, 0.8f, true);
    }

    @Override
    public void genSurfColumn(class_1936 world, class_2338 pos, Random random) {
        switch (random.nextInt(4)) {
            case 0: {
                if (this.validWall(world, pos.method_10074()) && this.validWall(world, pos.method_10095()) && this.validWall(world, pos.method_10072()) && this.validWall(world, pos.method_10078()) && this.validWall(world, pos.method_10067())) {
                    BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_10164.method_9564());
                    break;
                }
                BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_10114.method_9564());
                break;
            }
            case 1: {
                BlocksHelper.setWithoutUpdate(world, pos, class_2246.field_10114.method_9564());
            }
            case 2: {
                BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.NETHERRACK_MOSS.method_9564());
            }
        }
        for (int i = 1; i < random.nextInt(3); ++i) {
            class_2338 down = pos.method_10087(i);
            if (random.nextInt(3) != 0 || !BlocksHelper.isNetherGround(world.method_8320(down))) continue;
            BlocksHelper.setWithoutUpdate(world, down, class_2246.field_10114.method_9564());
        }
    }

    protected boolean validWall(class_1936 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return BlocksHelper.isLava(state) || BlocksHelper.isNetherGround(state);
    }
}

