/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import paulevs.betternether.blocks.BlockBaseNotFull;
import paulevs.betternether.blocks.materials.Materials;
import paulevs.betternether.registry.BlocksRegistry;

public class BlockBrownLargeMushroom
extends BlockBaseNotFull {
    private static final class_265 TOP_CENTER_SHAPE = class_2248.method_9541((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 TOP_EDGE_SHAPE = class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final class_2754<BrownMushroomShape> SHAPE = class_2754.method_11850((String)"shape", BrownMushroomShape.class);
    private static final BrownMushroomShape[] ROT_SIDE = new BrownMushroomShape[]{BrownMushroomShape.SIDE_N, BrownMushroomShape.SIDE_E, BrownMushroomShape.SIDE_S, BrownMushroomShape.SIDE_W};
    private static final BrownMushroomShape[] ROT_CORNER = new BrownMushroomShape[]{BrownMushroomShape.CORNER_N, BrownMushroomShape.CORNER_E, BrownMushroomShape.CORNER_S, BrownMushroomShape.CORNER_W};

    public BlockBrownLargeMushroom() {
        super((class_2248.class_2251)Materials.makeWood(class_3620.field_15977).nonOpaque());
        this.setDropItself(false);
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        BrownMushroomShape shape = (BrownMushroomShape)((Object)state.method_11654(SHAPE));
        return shape == BrownMushroomShape.BOTTOM || shape == BrownMushroomShape.MIDDLE ? new class_1799((class_1935)BlocksRegistry.MUSHROOM_STEM) : new class_1799((class_1935)class_1802.field_17516);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{SHAPE});
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        BrownMushroomShape shape = (BrownMushroomShape)((Object)state.method_11654(SHAPE));
        if (shape == BrownMushroomShape.TOP) {
            return TOP_CENTER_SHAPE;
        }
        if (shape == BrownMushroomShape.MIDDLE || shape == BrownMushroomShape.BOTTOM) {
            return MIDDLE_SHAPE;
        }
        return TOP_EDGE_SHAPE;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        BrownMushroomShape shape = (BrownMushroomShape)((Object)state.method_11654(SHAPE));
        int index = this.getRotationIndex(shape, ROT_SIDE);
        if (index < 0) {
            index = this.getRotationIndex(shape, ROT_CORNER);
            if (index < 0) {
                return state;
            }
            int offset = this.rotOffset(rotation);
            return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)ROT_CORNER[index + offset & 3]));
        }
        int offset = this.rotOffset(rotation);
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)ROT_SIDE[index + offset & 3]));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        BrownMushroomShape shape = (BrownMushroomShape)((Object)state.method_11654(SHAPE));
        int index = this.getRotationIndex(shape, ROT_SIDE);
        if (index < 0) {
            index = this.getRotationIndex(shape, ROT_CORNER);
            if (index < 0) {
                return state;
            }
            if (mirror == class_2415.field_11301) {
                if (shape == BrownMushroomShape.CORNER_E) {
                    shape = BrownMushroomShape.CORNER_W;
                } else if (shape == BrownMushroomShape.CORNER_W) {
                    shape = BrownMushroomShape.CORNER_E;
                }
            } else if (mirror == class_2415.field_11300) {
                if (shape == BrownMushroomShape.CORNER_N) {
                    shape = BrownMushroomShape.CORNER_S;
                } else if (shape == BrownMushroomShape.CORNER_S) {
                    shape = BrownMushroomShape.CORNER_N;
                }
            }
            return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)shape));
        }
        if (mirror == class_2415.field_11301) {
            if (shape == BrownMushroomShape.SIDE_E) {
                shape = BrownMushroomShape.SIDE_W;
            } else if (shape == BrownMushroomShape.SIDE_W) {
                shape = BrownMushroomShape.SIDE_E;
            }
        } else if (mirror == class_2415.field_11300) {
            if (shape == BrownMushroomShape.SIDE_N) {
                shape = BrownMushroomShape.SIDE_S;
            } else if (shape == BrownMushroomShape.SIDE_S) {
                shape = BrownMushroomShape.SIDE_N;
            }
        }
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)shape));
    }

    private int getRotationIndex(BrownMushroomShape shape, BrownMushroomShape[] rotations) {
        for (int i = 0; i < 4; ++i) {
            if (shape != rotations[i]) continue;
            return i;
        }
        return -1;
    }

    private int rotOffset(class_2470 rotation) {
        if (rotation == class_2470.field_11467) {
            return 0;
        }
        if (rotation == class_2470.field_11463) {
            return 1;
        }
        if (rotation == class_2470.field_11464) {
            return 2;
        }
        return 3;
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        switch ((BrownMushroomShape)((Object)state.method_11654(SHAPE))) {
            case BOTTOM: {
                return state;
            }
            default: {
                return this.getStateIfSame(state, world, pos.method_10074());
            }
            case SIDE_E: 
            case CORNER_E: {
                return this.getStateIfSame(state, world, pos.method_10067());
            }
            case SIDE_N: 
            case CORNER_N: {
                return this.getStateIfSame(state, world, pos.method_10072());
            }
            case SIDE_S: 
            case CORNER_S: {
                return this.getStateIfSame(state, world, pos.method_10095());
            }
            case SIDE_W: 
            case CORNER_W: 
        }
        return this.getStateIfSame(state, world, pos.method_10078());
    }

    private class_2680 getStateIfSame(class_2680 state, class_1936 world, class_2338 pos) {
        return world.method_8320(pos).method_11614() == this ? state : class_2246.field_10124.method_9564();
    }

    public static enum BrownMushroomShape implements class_3542
    {
        TOP,
        SIDE_N,
        SIDE_S,
        SIDE_E,
        SIDE_W,
        CORNER_N,
        CORNER_S,
        CORNER_E,
        CORNER_W,
        MIDDLE,
        BOTTOM;


        public String method_15434() {
            return this.toString().toLowerCase();
        }
    }
}

