/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class Config {
    private static JsonObject config;
    private static boolean rewrite;

    public static void load() {
        File file = Config.getFile();
        if (file.exists()) {
            Gson gson = new Gson();
            try {
                FileReader reader = new FileReader(file);
                config = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (config == null) {
                    config = new JsonObject();
                    rewrite = true;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                config = new JsonObject();
                rewrite = true;
            }
        } else {
            config = new JsonObject();
            rewrite = true;
        }
    }

    public static void save() {
        if (rewrite) {
            File file = Config.getFile();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try {
                FileWriter writer = new FileWriter(file);
                String gstring = gson.toJson((JsonElement)config);
                writer.write(gstring);
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static File getFile() {
        return new File(String.format("./config/%s.json", "betternether"));
    }

    public static boolean getBoolean(String group, String name, boolean def) {
        name = name + "[def: " + def + "]";
        JsonObject jGroup = config.getAsJsonObject(group);
        if (jGroup != null) {
            JsonElement element = jGroup.get(name);
            if (element != null) {
                return element.getAsBoolean();
            }
            jGroup.addProperty(name, Boolean.valueOf(def));
            rewrite = true;
            return def;
        }
        JsonObject newGroup = new JsonObject();
        newGroup.addProperty(name, Boolean.valueOf(def));
        config.add(group, (JsonElement)newGroup);
        rewrite = true;
        return def;
    }

    public static float getFloat(String group, String name, float def) {
        name = name + "[def: " + def + "]";
        JsonObject jGroup = config.getAsJsonObject(group);
        if (jGroup != null) {
            JsonElement element = jGroup.get(name);
            if (element != null) {
                return element.getAsFloat();
            }
            jGroup.addProperty(name, (Number)Float.valueOf(def));
            rewrite = true;
            return def;
        }
        JsonObject newGroup = new JsonObject();
        newGroup.addProperty(name, (Number)Float.valueOf(def));
        config.add(group, (JsonElement)newGroup);
        rewrite = true;
        return def;
    }

    public static int getInt(String group, String name, int def) {
        name = name + "[def: " + def + "]";
        JsonObject jGroup = config.getAsJsonObject(group);
        if (jGroup != null) {
            JsonElement element = jGroup.get(name);
            if (element != null) {
                return element.getAsInt();
            }
            jGroup.addProperty(name, (Number)def);
            rewrite = true;
            return def;
        }
        JsonObject newGroup = new JsonObject();
        newGroup.addProperty(name, (Number)def);
        config.add(group, (JsonElement)newGroup);
        rewrite = true;
        return def;
    }

    public static String[] getStringArray(String group, String name, String[] def) {
        JsonObject jGroup = config.getAsJsonObject(group);
        if (jGroup != null) {
            JsonElement element = jGroup.get(name);
            if (element != null) {
                return Config.toStringArray(element.getAsJsonArray());
            }
            jGroup.add(name, (JsonElement)Config.toJsonArray(def));
            rewrite = true;
            return def;
        }
        JsonObject newGroup = new JsonObject();
        newGroup.add(name, (JsonElement)Config.toJsonArray(def));
        config.add(group, (JsonElement)newGroup);
        rewrite = true;
        return def;
    }

    private static String[] toStringArray(JsonArray array) {
        String[] result = new String[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            result[i] = array.get(i).getAsString();
        }
        return result;
    }

    private static JsonArray toJsonArray(String[] array) {
        JsonArray result = new JsonArray();
        for (String s : array) {
            result.add(s);
        }
        return result;
    }

    public static JsonArray getJsonArray(String group, String name, JsonArray def) {
        JsonObject jGroup = config.getAsJsonObject(group);
        if (jGroup != null) {
            JsonElement element = jGroup.get(name);
            if (element != null) {
                return element.getAsJsonArray();
            }
            jGroup.add(name, (JsonElement)def);
            rewrite = true;
            return def;
        }
        JsonObject newGroup = new JsonObject();
        newGroup.add(name, (JsonElement)def);
        config.add(group, (JsonElement)newGroup);
        rewrite = true;
        return def;
    }

    static {
        rewrite = false;
    }
}

