/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.structures.IStructure;

public class StructureCaves
implements IStructure {
    private static final boolean[][][] MASK = new boolean[16][24][16];
    private static final class_2338.class_2339 B_POS = new class_2338.class_2339();
    private static int offset = 12;
    private OpenSimplexNoise heightNoise;
    private OpenSimplexNoise rigidNoise;
    private OpenSimplexNoise distortX;
    private OpenSimplexNoise distortY;

    public StructureCaves(long seed) {
        Random random = new Random(seed);
        this.heightNoise = new OpenSimplexNoise(random.nextLong());
        this.rigidNoise = new OpenSimplexNoise(random.nextLong());
        this.distortX = new OpenSimplexNoise(random.nextLong());
        this.distortY = new OpenSimplexNoise(random.nextLong());
    }

    @Override
    public void generate(class_1936 world, class_2338 pos, Random random) {
        int wz;
        int z;
        int wx;
        int x;
        boolean isVoid = true;
        offset = (int)(this.getHeight(pos.method_10263() + 8, pos.method_10260() + 8) - 12.0);
        for (x = 0; x < 16; ++x) {
            wx = pos.method_10263() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.method_10260() + z;
                double height = this.getHeight(wx, wz);
                double rigid = this.getRigid(wx, wz);
                for (int y = 0; y < 24; ++y) {
                    int wy = offset + y;
                    double hRigid = Math.abs((double)wy - height);
                    double sdf = -this.opSmoothUnion(-hRigid / 30.0, -rigid, 0.15);
                    if (sdf < 0.15) {
                        StructureCaves.MASK[x][y][z] = true;
                        isVoid = false;
                        continue;
                    }
                    StructureCaves.MASK[x][y][z] = false;
                }
            }
        }
        if (isVoid) {
            return;
        }
        for (x = 0; x < 16; ++x) {
            wx = pos.method_10263() + x;
            for (z = 0; z < 16; ++z) {
                wz = pos.method_10260() + z;
                for (int y = 23; y >= 0; --y) {
                    int wy = offset + y;
                    B_POS.method_10103(wx, wy, wz);
                    if (!MASK[x][y][z] || !BlocksHelper.isNetherGroundMagma(world.method_8320((class_2338)B_POS))) continue;
                    if (world.method_8320(B_POS.method_10084()).method_11614() == class_2246.field_10541) {
                        BlocksHelper.setWithoutUpdate(world, (class_2338)B_POS, class_2246.field_10541.method_9564());
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate(world, (class_2338)B_POS, class_2246.field_10124.method_9564());
                }
            }
        }
    }

    private double getHeight(int x, int z) {
        return this.heightNoise.eval((double)x * 0.01, (double)z * 0.01) * 32.0 + 64.0;
    }

    private double getRigid(int x, int z) {
        return Math.abs(this.rigidNoise.eval((double)x * 0.02 + this.distortX.eval((double)x * 0.05, (double)z * 0.05) * 0.2, (double)z * 0.02 + this.distortY.eval((double)x * 0.05, (double)z * 0.05) * 0.2)) * 0.6;
    }

    private double mix(double dist1, double dist2, double blend) {
        return dist1 * (1.0 - blend) + dist2 * blend;
    }

    private double opSmoothUnion(double dist1, double dist2, double blend) {
        double h = 0.5 + 0.5 * (dist2 - dist1) / blend;
        h = h > 1.0 ? 1.0 : (h < 0.0 ? 0.0 : h);
        return this.mix(dist2, dist1, h) - blend * h * (1.0 - h);
    }

    public boolean isInCave(int x, int y, int z) {
        int y2 = y - offset;
        if (y2 >= 0 && y < 24) {
            return MASK[x][y2][z];
        }
        return false;
    }
}

