/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3284;
import net.minecraft.class_4538;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.config.Config;
import paulevs.betternether.registry.BlocksRegistry;
import paulevs.betternether.structures.StructureCaves;
import paulevs.betternether.structures.StructureType;
import paulevs.betternether.world.BiomeMap;
import paulevs.betternether.world.structures.CityFeature;

public class BNWorldGenerator {
    private static boolean hasCleaningPass;
    private static boolean hasFixPass;
    private static float oreDensity;
    private static float structureDensity;
    private static final class_2680 AIR;
    private static class_2338.class_2339 popPos;
    private static final NetherBiome[][][] BIOMES;
    private static BiomeMap map;
    private static int sizeXZ;
    private static int sizeY;
    private static final List<class_2338> LIST_FLOOR;
    private static final List<class_2338> LIST_WALL;
    private static final List<class_2338> LIST_CEIL;
    private static final List<class_2338> LIST_LAVA;
    private static StructureCaves caves;
    private static NetherBiome biome;
    public static final class_3195<class_3111> CITY;

    public static void onModInit() {
        hasCleaningPass = Config.getBoolean("generator_world", "terrain_cleaning_pass", true);
        hasFixPass = Config.getBoolean("generator_world", "world_fixing_pass", true);
        oreDensity = Config.getFloat("generator_world", "cincinnasite_ore_density", 9.765625E-4f);
        structureDensity = Config.getFloat("generator_world", "structures_density", 0.03125f);
        sizeXZ = Config.getInt("generator_world", "biome_size_xz", 200);
        sizeY = Config.getInt("generator_world", "biome_size_y", 40);
        if (Config.getBoolean("generator_world", "generate_cities", true)) {
            class_1972.field_9461.method_8710(CITY.method_23397((class_3037)class_3037.field_13603));
            class_1972.field_9461.method_8719(class_2893.class_2895.field_13174, CITY.method_23397((class_3037)class_3037.field_13603).method_23388(class_3284.field_14250.method_23475((class_2998)class_2998.field_13436)));
            class_3031.field_13557.put((Object)"nether_city", CITY);
        }
    }

    public static void init(class_1936 world) {
        if (map == null) {
            long seed = world.method_8412();
            map = new BiomeMap(seed, sizeXZ, sizeY);
            caves = new StructureCaves(seed);
        }
    }

    public static void clearCache() {
        map.clearCache();
    }

    private static void makeBiomeArray(int sx, int sz) {
        for (int x = 0; x < 4; ++x) {
            int wx = sx + (x << 2);
            for (int y = 0; y < 32; ++y) {
                int wy = y << 2;
                for (int z = 0; z < 4; ++z) {
                    int wz = sz + (z << 2);
                    BNWorldGenerator.BIOMES[x][y][z] = BNWorldGenerator.getBiome(wx, wy, wz);
                }
            }
        }
    }

    private static NetherBiome getBiomeLocal(int x, int y, int z, Random random) {
        int px = x + random.nextInt(5) - 2 >> 2;
        int py = y + random.nextInt(5) - 2 >> 2;
        int pz = z + random.nextInt(5) - 2 >> 2;
        return BIOMES[BNWorldGenerator.clamp(px, 3)][BNWorldGenerator.clamp(py, 31)][BNWorldGenerator.clamp(pz, 3)];
    }

    public static NetherBiome getBiome(int x, int y, int z) {
        NetherBiome biome = map.getBiome(x, y > 30 ? y : 30, z);
        if (biome.hasEdge() || biome.hasParrent() && biome.getParrentBiome().hasEdge()) {
            int d;
            NetherBiome search = biome;
            if (biome.hasParrent()) {
                search = biome.getParrentBiome();
            }
            boolean edge = !search.isSame(map.getBiome(x + (d = (int)Math.ceil((float)search.getEdgeSize() / 4.0f) * 4), y, z));
            edge = edge || !search.isSame(map.getBiome(x - d, y, z));
            edge = edge || !search.isSame(map.getBiome(x, y + d, z));
            edge = edge || !search.isSame(map.getBiome(x, y - d, z));
            edge = edge || !search.isSame(map.getBiome(x, y, z + d));
            edge = edge || !search.isSame(map.getBiome(x, y, z - d));
            edge = edge || !search.isSame(map.getBiome(x - d, y - d, z - d));
            edge = edge || !search.isSame(map.getBiome(x + d, y - d, z - d));
            edge = edge || !search.isSame(map.getBiome(x - d, y - d, z + d));
            edge = edge || !search.isSame(map.getBiome(x + d, y - d, z + d));
            edge = edge || !search.isSame(map.getBiome(x - d, y + d, z - d));
            edge = edge || !search.isSame(map.getBiome(x + d, y + d, z - d));
            edge = edge || !search.isSame(map.getBiome(x - d, y + d, z + d));
            boolean bl = edge = edge || !search.isSame(map.getBiome(x + d, y + d, z + d));
            if (edge) {
                biome = search.getEdge();
            }
        }
        return biome;
    }

    private static int clamp(int x, int max) {
        return x < 0 ? 0 : (x > max ? max : x);
    }

    public static void populate(class_1936 world, int sx, int sz, Random random) {
        BNWorldGenerator.makeBiomeArray(sx, sz);
        if (random.nextFloat() < structureDensity) {
            popPos.method_10103(sx + random.nextInt(16), 32 + random.nextInt(88), sz + random.nextInt(16));
            StructureType type = StructureType.FLOOR;
            boolean isAir = world.method_8320((class_2338)popPos).method_11588();
            boolean airUp = world.method_8320(popPos.method_10084()).method_11588() && world.method_8320(popPos.method_10086(3)).method_11588();
            boolean airDown = world.method_8320(popPos.method_10074()).method_11588() && world.method_8320(popPos.method_10087(3)).method_11588();
            NetherBiome biome = BNWorldGenerator.getBiomeLocal(popPos.method_10263() - sx, popPos.method_10264(), popPos.method_10260() - sz, random);
            if (!(isAir || airUp || airDown)) {
                type = StructureType.UNDER;
            } else if (!biome.hasCeilStructures() || random.nextBoolean()) {
                while (world.method_8320(popPos.method_10074()).method_11588() && popPos.method_10264() > 1) {
                    popPos.method_10099(popPos.method_10264() - 1);
                }
            } else {
                while (!BlocksHelper.isNetherGroundMagma(world.method_8320(popPos.method_10084())) && popPos.method_10264() < 127) {
                    popPos.method_10099(popPos.method_10264() + 1);
                }
                type = StructureType.CEIL;
            }
            biome = BNWorldGenerator.getBiomeLocal(popPos.method_10263() - sx, popPos.method_10264(), popPos.method_10260() - sz, random);
            if (world.method_22347((class_2338)popPos)) {
                class_2680 up;
                if (type == StructureType.FLOOR) {
                    class_2680 down = world.method_8320(popPos.method_10074());
                    if (BlocksHelper.isLava(down)) {
                        biome.genLavaBuildings(world, (class_2338)popPos, random);
                    } else if (BlocksHelper.isNetherGroundMagma(down)) {
                        biome.genFloorBuildings(world, (class_2338)popPos, random);
                    }
                } else if (type == StructureType.CEIL && BlocksHelper.isNetherGroundMagma(up = world.method_8320(popPos.method_10084()))) {
                    biome.genCeilBuildings(world, (class_2338)popPos, random);
                }
            } else {
                biome.genUnderBuildings(world, (class_2338)popPos, random);
            }
        }
        LIST_LAVA.clear();
        LIST_FLOOR.clear();
        LIST_WALL.clear();
        LIST_CEIL.clear();
        int ex = sx + 16;
        int ez = sz + 16;
        for (int x = 0; x < 16; ++x) {
            int wx = sx + x;
            for (int z = 0; z < 16; ++z) {
                int wz = sz + z;
                for (int y = 5; y < 126; ++y) {
                    if (caves.isInCave(x, y, z)) continue;
                    popPos.method_10103(wx, y, wz);
                    class_2680 state = world.method_8320((class_2338)popPos);
                    boolean lava = BlocksHelper.isLava(state);
                    if (!lava && !BlocksHelper.isNetherGroundMagma(state)) continue;
                    biome = BNWorldGenerator.getBiomeLocal(x, y, z, random);
                    if (!lava && world.method_22347(popPos.method_10084())) {
                        biome.genSurfColumn(world, (class_2338)popPos, random);
                    }
                    if ((x + y + z & 1) == 0) {
                        if (world.method_22347(popPos.method_10084())) {
                            if (lava) {
                                LIST_LAVA.add(popPos.method_10084());
                            } else {
                                LIST_FLOOR.add(new class_2338((class_2382)popPos.method_10084()));
                            }
                        } else if (world.method_22347(popPos.method_10074())) {
                            LIST_CEIL.add(new class_2338((class_2382)popPos.method_10074()));
                        } else {
                            boolean bNorth = world.method_22347(popPos.method_10095());
                            boolean bSouth = world.method_22347(popPos.method_10072());
                            boolean bEast = world.method_22347(popPos.method_10078());
                            boolean bWest = world.method_22347(popPos.method_10067());
                            if (bNorth || bSouth || bEast || bWest) {
                                class_2338 objPos = null;
                                objPos = bNorth ? popPos.method_10095() : (bSouth ? popPos.method_10072() : (bEast ? popPos.method_10078() : popPos.method_10067()));
                                if (popPos.method_10263() >= sx && popPos.method_10263() < ex && popPos.method_10260() >= sz && popPos.method_10260() < ez) {
                                    boolean bDown = world.method_22347(objPos.method_10074());
                                    boolean bUp = world.method_22347(objPos.method_10084());
                                    if (bDown && bUp) {
                                        LIST_WALL.add(new class_2338((class_2382)objPos));
                                    }
                                }
                            }
                        }
                    }
                    if (!(random.nextFloat() < oreDensity)) continue;
                    BNWorldGenerator.spawnOre(BlocksRegistry.CINCINNASITE_ORE.method_9564(), world, (class_2338)popPos, random);
                }
            }
        }
        for (class_2338 pos : LIST_LAVA) {
            if (!world.method_22347(pos)) continue;
            biome = BNWorldGenerator.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random);
            biome.genLavaObjects(world, pos, random);
        }
        for (class_2338 pos : LIST_FLOOR) {
            if (!world.method_22347(pos)) continue;
            biome = BNWorldGenerator.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random);
            biome.genFloorObjects(world, pos, random);
        }
        for (class_2338 pos : LIST_WALL) {
            if (!world.method_22347(pos)) continue;
            biome = BNWorldGenerator.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random);
            biome.genWallObjects(world, pos, random);
        }
        for (class_2338 pos : LIST_CEIL) {
            if (!world.method_22347(pos)) continue;
            biome = BNWorldGenerator.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random);
            biome.genCeilObjects(world, pos, random);
        }
    }

    public static void prePopulate(class_1936 world, int cx, int cz) {
        int wx = cx << 4;
        int wz = cz << 4;
        popPos.method_10103(wx, 0, wz);
        caves.generate(world, (class_2338)popPos, world.method_8409());
        if (hasCleaningPass) {
            class_2338 up;
            ArrayList<class_2338> pos = new ArrayList<class_2338>();
            for (int y = 32; y < 110; ++y) {
                popPos.method_10099(y);
                for (int x = 0; x < 16; ++x) {
                    popPos.method_20787(x + wx);
                    for (int z = 0; z < 16; ++z) {
                        popPos.method_20788(z + wz);
                        if (!BNWorldGenerator.canReplace(world, (class_2338)popPos)) continue;
                        up = popPos.method_10084();
                        class_2338 down = popPos.method_10074();
                        class_2338 north = popPos.method_10095();
                        class_2338 south = popPos.method_10072();
                        class_2338 east = popPos.method_10078();
                        class_2338 west = popPos.method_10067();
                        if (world.method_22347(north) && world.method_22347(south)) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(east) && world.method_22347(west)) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(up) && world.method_22347(down)) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(popPos.method_10095().method_10078().method_10074()) && world.method_22347(popPos.method_10072().method_10067().method_10084())) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(popPos.method_10072().method_10078().method_10074()) && world.method_22347(popPos.method_10095().method_10067().method_10084())) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (world.method_22347(popPos.method_10095().method_10067().method_10074()) && world.method_22347(popPos.method_10072().method_10078().method_10084())) {
                            pos.add(new class_2338((class_2382)popPos));
                            continue;
                        }
                        if (!world.method_22347(popPos.method_10072().method_10067().method_10074()) || !world.method_22347(popPos.method_10095().method_10078().method_10084())) continue;
                        pos.add(new class_2338((class_2382)popPos));
                    }
                }
            }
            for (class_2338 p : pos) {
                BlocksHelper.setWithoutUpdate(world, p, AIR);
                up = p.method_10084();
                class_2680 state = world.method_8320(up);
                if (state.method_11614().method_9558(state, (class_4538)world, up)) continue;
                BlocksHelper.setWithoutUpdate(world, up, AIR);
            }
        }
    }

    private static boolean canReplace(class_1936 world, class_2338 pos) {
        return BlocksHelper.isNetherGround(world.method_8320(pos));
    }

    private static void spawnOre(class_2680 state, class_1936 world, class_2338 pos, Random random) {
        for (int i = 0; i < 6 + random.nextInt(11); ++i) {
            class_2338 local = pos.method_10069(random.nextInt(3), random.nextInt(3), random.nextInt(3));
            if (!BlocksHelper.isNetherrack(world.method_8320(local))) continue;
            BlocksHelper.setWithoutUpdate(world, local, state);
        }
    }

    public static void cleaningPass(class_1936 world, int sx, int sz) {
        if (hasFixPass) {
            BNWorldGenerator.fixBlocks(world, sx, 30, sz, sx + 15, 110, sz + 15);
        }
    }

    private static void fixBlocks(class_1936 world, int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int y = y1; y <= y2; ++y) {
            popPos.method_10099(y);
            for (int x = x1; x <= x2; ++x) {
                popPos.method_20787(x);
                for (int z = z1; z <= z2; ++z) {
                    popPos.method_20788(z);
                    class_2680 state = world.method_8320((class_2338)popPos);
                    if (!state.method_11591((class_4538)world, (class_2338)popPos)) {
                        BlocksHelper.setWithoutUpdate(world, (class_2338)popPos, AIR);
                        continue;
                    }
                    if (!state.method_11619() && world.method_8320(popPos.method_10084()).method_11614() == class_2246.field_10266) {
                        BlocksHelper.setWithoutUpdate(world, (class_2338)popPos, class_2246.field_10266.method_9564());
                        continue;
                    }
                    if (!BlocksHelper.isLava(state) || !world.method_22347(popPos.method_10084()) || !world.method_22347(popPos.method_10074())) continue;
                    BlocksHelper.setWithoutUpdate(world, (class_2338)popPos, AIR);
                }
            }
        }
    }

    static {
        AIR = class_2246.field_10124.method_9564();
        popPos = new class_2338.class_2339();
        BIOMES = new NetherBiome[4][32][4];
        LIST_FLOOR = new ArrayList<class_2338>(4096);
        LIST_WALL = new ArrayList<class_2338>(4096);
        LIST_CEIL = new ArrayList<class_2338>(4096);
        LIST_LAVA = new ArrayList<class_2338>(1024);
        CITY = (class_3195)class_2378.method_10230((class_2378)class_2378.field_16644, (class_2960)new class_2960("betternether", "nether_city"), (Object)((Object)new CityFeature(class_3111::method_13565)));
    }
}

