/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.ArrayList;
import java.util.Random;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.registry.BiomesRegistry;
import paulevs.betternether.world.BiomeMap;

public class BiomeChunk {
    protected static final int WIDTH = 16;
    private static final int SM_WIDTH = 8;
    private static final int MASK_A = 7;
    private static final int MASK_C = 15;
    private static final ArrayList<NetherBiome> SURROUNDING = new ArrayList(6);
    private static final ArrayList<NetherBiome> BIOME_NO_REPEATS = new ArrayList(BiomesRegistry.getBiomeCount());
    private final int sm_height;
    private final int maxY;
    private final int maskB;
    private final NetherBiome[][][] PreBio;
    private final NetherBiome[][][] biomes;

    public BiomeChunk(BiomeMap map, Random random) {
        int z;
        int x;
        int y;
        this.sm_height = this.clampOne(map.maxHeight >> 1);
        this.maskB = this.sm_height - 1;
        this.maxY = map.maxHeight - 1;
        this.PreBio = new NetherBiome[this.sm_height][8][8];
        this.biomes = new NetherBiome[map.maxHeight][16][16];
        for (y = 0; y < this.sm_height; ++y) {
            for (x = 0; x < 8; ++x) {
                for (z = 0; z < 8; ++z) {
                    this.PreBio[y][x][z] = BiomesRegistry.getBiome(random);
                }
            }
        }
        for (y = 0; y < this.sm_height; ++y) {
            for (x = 0; x < 8; ++x) {
                for (z = 0; z < 8; ++z) {
                    if ((x + y + z & 1) != 0) continue;
                    if (y - 1 >= 0) {
                        SURROUNDING.add(this.PreBio[y - 1][x][z]);
                    }
                    if (y + 1 < this.sm_height) {
                        SURROUNDING.add(this.PreBio[y + 1][x][z]);
                    }
                    if (x - 1 >= 0) {
                        SURROUNDING.add(this.PreBio[y][x - 1][z]);
                    }
                    if (x + 1 < 8) {
                        SURROUNDING.add(this.PreBio[y][x + 1][z]);
                    }
                    if (z - 1 >= 0) {
                        SURROUNDING.add(this.PreBio[y][x][z - 1]);
                    }
                    if (z + 1 < 8) {
                        SURROUNDING.add(this.PreBio[y][x][z + 1]);
                    }
                    this.PreBio[y][x][z] = this.getNonRepeat(random, this.PreBio[y][x][z]);
                }
            }
        }
        for (y = 0; y < map.maxHeight; ++y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    this.biomes[y][x][z] = this.PreBio[this.offsetY(y, random)][this.offsetXZ(x, random)][this.offsetXZ(z, random)].getSubBiome(random);
                }
            }
        }
    }

    public NetherBiome getBiome(int x, int y, int z) {
        return this.biomes[this.clamp(y)][x & 0xF][z & 0xF];
    }

    private int offsetXZ(int x, Random random) {
        return x + random.nextInt(2) >> 1 & 7;
    }

    private int offsetY(int y, Random random) {
        return y + random.nextInt(2) >> 1 & this.maskB;
    }

    private int clamp(int y) {
        return y < 0 ? 0 : (y > this.maxY ? this.maxY : y);
    }

    private int clampOne(int x) {
        return x < 1 ? 1 : x;
    }

    private NetherBiome getNonRepeat(Random random, NetherBiome center) {
        BIOME_NO_REPEATS.addAll(BiomesRegistry.getBiomesList());
        BIOME_NO_REPEATS.removeAll(SURROUNDING);
        NetherBiome result = center;
        if (!BIOME_NO_REPEATS.isEmpty()) {
            result = BIOME_NO_REPEATS.get(random.nextInt(BIOME_NO_REPEATS.size()));
        }
        BIOME_NO_REPEATS.clear();
        SURROUNDING.clear();
        return result;
    }
}

