/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2919;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.world.BiomeChunk;

public class BiomeMap {
    private static final HashMap<class_1923, BiomeChunk> MAPS = new HashMap();
    private static final class_2919 RANDOM = new class_2919();
    private final int sizeXZ;
    private final int sizeY;
    protected final int maxHeight;
    private final int depth;
    private final int size;
    private final OpenSimplexNoise noiseX;
    private final OpenSimplexNoise noiseY;
    private final OpenSimplexNoise noiseZ;

    public BiomeMap(long seed, int sizeXZ, int sizeY) {
        RANDOM.setSeed(seed);
        this.noiseX = new OpenSimplexNoise(RANDOM.nextLong());
        this.noiseY = new OpenSimplexNoise(RANDOM.nextLong());
        this.noiseZ = new OpenSimplexNoise(RANDOM.nextLong());
        this.sizeXZ = sizeXZ;
        this.sizeY = sizeY;
        this.maxHeight = 128 / sizeY;
        this.depth = (int)Math.ceil(Math.log(Math.max(sizeXZ, sizeY)) / Math.log(2.0)) - 1;
        this.size = 1 << this.depth;
    }

    public void clearCache() {
        if (MAPS.size() > 16) {
            MAPS.clear();
        }
    }

    public NetherBiome getBiome(int bx, int by, int bz) {
        int x = bx * this.size / this.sizeXZ;
        int y = by * this.size / this.sizeY;
        int z = bz * this.size / this.sizeXZ;
        int nx = x;
        int ny = y;
        int nz = z;
        for (int i = 0; i < this.depth; ++i) {
            nx = (int)Math.round((double)x + this.noiseX.eval(y, z) * 0.5 + 0.5) >> 1;
            ny = (int)Math.round((double)y + this.noiseY.eval(x, z) * 0.5 + 0.5) >> 1;
            nz = (int)Math.round((double)z + this.noiseZ.eval(x, y) * 0.5 + 0.5) >> 1;
            x = nx;
            y = ny;
            z = nz;
        }
        class_1923 cpos = new class_1923((int)Math.floor((double)x / 16.0), (int)Math.floor((double)z / 16.0));
        BiomeChunk chunk = MAPS.get(cpos);
        if (chunk == null) {
            RANDOM.method_12659(cpos.field_9181, cpos.field_9180);
            chunk = new BiomeChunk(this, (Random)RANDOM);
            MAPS.put(cpos, chunk);
        }
        return chunk.getBiome(x, y, z);
    }

    public NetherBiome getBiome(class_2338 pos) {
        return this.getBiome(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }
}

