/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world.structures.city;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3818;
import net.minecraft.class_3819;
import net.minecraft.class_3821;
import net.minecraft.class_3825;
import net.minecraft.class_3826;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.structures.StructureNBT;
import paulevs.betternether.world.structures.city.BoundingBox;

public class StructureCityBuilding
extends StructureNBT {
    protected static final class_2680 AIR = class_2246.field_10124.method_9564();
    protected static final class_3491 REPLACE = StructureCityBuilding.makeProcessorReplace();
    private BoundingBox bb;
    public class_2338[] ends;
    private class_2350[] dirs;
    private class_2338 rotationOffset;
    private int offsetY;

    public StructureCityBuilding(String structure) {
        super(structure);
        this.offsetY = 0;
        this.init();
    }

    public StructureCityBuilding(String structure, int offsetY) {
        super(structure);
        this.offsetY = offsetY;
        this.init();
    }

    protected StructureCityBuilding(class_2960 location, class_3499 structure) {
        super(location, structure);
        this.init();
    }

    private void init() {
        class_2338 size = this.structure.method_15160();
        this.bb = new BoundingBox(size);
        List map = this.structure.method_15165(class_2338.field_10980, new class_3492(), class_2246.field_10465, false);
        this.ends = new class_2338[map.size()];
        this.dirs = new class_2350[map.size()];
        int i = 0;
        class_2338 center = new class_2338(size.method_10263() >> 1, size.method_10264(), size.method_10260() >> 1);
        for (class_3499.class_3501 info : map) {
            this.ends[i] = info.field_15597;
            this.dirs[i++] = this.getDir(info.field_15597.method_10069(-center.method_10263(), 0, -center.method_10260()));
        }
        this.rotationOffset = new class_2338(0, 0, 0);
        this.rotation = class_2470.field_11467;
    }

    private class_2350 getDir(class_2338 pos) {
        int az;
        int ax = Math.abs(pos.method_10263());
        int mx = Math.max(ax, az = Math.abs(pos.method_10260()));
        if (mx == ax) {
            if (pos.method_10263() > 0) {
                return class_2350.field_11034;
            }
            return class_2350.field_11039;
        }
        if (pos.method_10260() > 0) {
            return class_2350.field_11035;
        }
        return class_2350.field_11043;
    }

    public BoundingBox getBoungingBox() {
        return this.bb;
    }

    public void place(class_1936 world, class_2338 pos) {
        class_2338 p = pos.method_10081((class_2382)this.rotationOffset);
        this.structure.method_15182(world, p, new class_3492().method_15123(this.rotation));
        for (class_2338 rep : this.ends) {
            BlocksHelper.setWithoutUpdate(world, rep.method_10081((class_2382)pos), AIR);
        }
        for (int x = 0; x < this.bb.x2; ++x) {
            for (int z = 0; z < this.bb.z2; ++z) {
                int d;
                p = pos.method_10069(x, 0, z);
                class_2680 state = world.method_8320(p);
                if (!state.method_21743((class_1922)world, p)) continue;
                for (d = 1; d < pos.method_10264() - 5 && !BlocksHelper.isNetherGroundMagma(world.method_8320(p.method_10087(d))); ++d) {
                }
                for (int y = 1; y < d; ++y) {
                    BlocksHelper.setWithoutUpdate(world, p.method_10087(y), state);
                }
            }
        }
    }

    protected class_2470 mirrorRotation(class_2470 r) {
        switch (r) {
            case field_11463: {
                return class_2470.field_11465;
            }
        }
        return r;
    }

    public void placeInChunk(class_1936 world, class_2338 pos, class_3341 boundingBox) {
        class_2338 p = pos.method_10081((class_2382)this.rotationOffset);
        this.structure.method_15182(world, p, new class_3492().method_15123(this.rotation).method_15125(this.mirror).method_15126(boundingBox).method_16184(REPLACE));
    }

    public class_2338[] getEnds() {
        return this.ends;
    }

    public int getEndsCount() {
        return this.ends.length;
    }

    public class_2338 getOffsettedPos(int index) {
        return this.ends[index].method_10093(this.dirs[index]);
    }

    public class_2338 getPos(int index) {
        return this.ends[index];
    }

    public StructureCityBuilding getRotated(class_2470 rotation) {
        StructureCityBuilding building = this.clone();
        building.rotation = rotation;
        building.rotationOffset = building.structure.method_15160().method_10070(rotation);
        int x = building.rotationOffset.method_10263();
        int z = building.rotationOffset.method_10260();
        x = x < 0 ? -x - 1 : 0;
        z = z < 0 ? -z - 1 : 0;
        building.rotationOffset = new class_2338(x, 0, z);
        for (int i = 0; i < building.dirs.length; ++i) {
            building.dirs[i] = this.rotated(building.dirs[i], rotation);
            building.ends[i] = building.ends[i].method_10070(rotation).method_10081((class_2382)building.rotationOffset);
        }
        building.bb.rotate(rotation);
        building.offsetY = this.offsetY;
        return building;
    }

    public StructureCityBuilding getRandomRotated(Random random) {
        return this.getRotated(class_2470.values()[random.nextInt(4)]);
    }

    public StructureCityBuilding clone() {
        return new StructureCityBuilding(this.location, this.structure);
    }

    private class_2350 rotated(class_2350 dir, class_2470 rotation) {
        class_2350 f;
        switch (rotation) {
            case field_11463: {
                f = dir.method_10170();
                break;
            }
            case field_11464: {
                f = dir.method_10153();
                break;
            }
            case field_11465: {
                f = dir.method_10160();
                break;
            }
            default: {
                f = dir;
            }
        }
        return f;
    }

    public int getYOffset() {
        return this.offsetY;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    private static class_3491 makeProcessorReplace() {
        return new class_3826((List)ImmutableList.of((Object)new class_3821((class_3825)new class_3819(class_2246.field_10465), (class_3825)class_3818.field_16868, class_2246.field_10124.method_9564())));
    }

    @Override
    public class_3341 getBoundingBox(class_2338 pos) {
        return this.structure.method_16187(new class_3492().method_15123(this.rotation).method_15125(this.mirror), pos.method_10081((class_2382)this.rotationOffset));
    }

    @Override
    public StructureCityBuilding setRotation(class_2470 rotation) {
        this.rotation = rotation;
        this.rotationOffset = this.structure.method_15160().method_10070(rotation);
        return this;
    }
}

