/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.client.render.entity.midnight;

import com.mushroom.midnight.client.render.LayerRendererEmissive;
import com.mushroom.midnight.common.entity.creature.EntityNightStag;
import dev.itsmeow.betteranimals.client.model.ModelNewNightstag;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RenderNewNightStag
extends RenderLiving<EntityNightStag> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("betteranimals", "textures/mobs/midnight/nightstag.png");
    private static final ResourceLocation EMISSIVE_TEXTURE = new ResourceLocation("betteranimals", "textures/mobs/midnight/nightstag_glow.png");
    private static final int FLICK_BRIGHT_LOW = 50;
    private static final int FLICK_BRIGHT_UP = 200;
    private static final int PULSE_BRIGHT_LOW = 200;
    private static final int PULSE_BRIGHT_UP = 240;
    private static float flicker;
    private static float prevFlicker;

    public RenderNewNightStag(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelNewNightstag(), 0.0f);
        this.func_177094_a((LayerRenderer)new LayerRendererEmissive(this.field_77045_g, EMISSIVE_TEXTURE, RenderNewNightStag::computeBrightness, RenderNewNightStag::computeColor));
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            prevFlicker = flicker;
            double targetFlicker = Math.random();
            targetFlicker *= targetFlicker;
            flicker = (float)((double)flicker + (targetFlicker - (double)flicker) * 0.5);
        }
    }

    private static int computeColor(EntityNightStag entity, float partialTicks) {
        switch (entity.getAntlerType()) {
            case 1: {
                return 0xFF6666;
            }
            case 2: {
                return 0xBBFF99;
            }
            case 3: {
                return 0x99FFFF;
            }
            case 4: {
                return 16755328;
            }
            case 5: {
                return 14916828;
            }
            case 6: {
                return 14122192;
            }
            case 7: {
                return 0xF2F2F2;
            }
            case 8: {
                return 0x6699FF;
            }
        }
        return 8409526;
    }

    private static int computeBrightness(EntityNightStag entity, float partialTicks) {
        double totalTicks = (float)entity.field_70173_aa + partialTicks;
        float flicker = RenderNewNightStag.computeFlicker(totalTicks, partialTicks);
        float pulse = (float)((Math.sin(totalTicks * 0.125) + 1.0) * 0.5);
        float health = entity.func_110143_aJ() / entity.func_110138_aP();
        float flickerBrightness = 50.0f + 150.0f * flicker;
        float healthyBrightness = 200.0f + 40.0f * pulse;
        return MathHelper.func_76141_d((float)(flickerBrightness * (1.0f - health) + healthyBrightness * health));
    }

    private static float computeFlicker(double totalTicks, float partialTicks) {
        float lerpedFlicker = prevFlicker + (flicker - prevFlicker) * partialTicks;
        float pulse = (float)(Math.sin(totalTicks * 0.2) + 1.0) * 0.4f;
        return MathHelper.func_76131_a((float)(lerpedFlicker + pulse), (float)0.0f, (float)1.0f);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityNightStag entity) {
        return TEXTURE;
    }

    protected void preRenderCallback(EntityNightStag entity, float partialTicks) {
        super.func_77041_b((EntityLivingBase)entity, partialTicks);
        if (entity.func_70631_g_()) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }
}

