/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.compat;

import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuarkUtil {
    public static ListMultimap<RandomTextureType, ResourceLocation> textures;

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getRandomTexture(Entity e, RandomTextureType type) {
        return QuarkUtil.getRandomTexture(e, type, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getRandomTexture(Entity e, RandomTextureType type, boolean choose) {
        List styles = textures.get((Object)type);
        if (!choose) {
            return (ResourceLocation)styles.get(styles.size() - 1);
        }
        UUID id = e.func_110124_au();
        int choice = Math.abs((int)(id.getMostSignificantBits() % (long)styles.size()));
        return (ResourceLocation)styles.get(choice);
    }

    public static void registerTextures(RandomTextureType type, int count, ResourceLocation vanilla) {
        String name = type.name().toLowerCase();
        for (int i = 1; i < count + 1; ++i) {
            textures.put((Object)type, (Object)new ResourceLocation("betteranimals", String.format("textures/mobs/quark/%s%d.png", name, i)));
        }
        if (vanilla != null) {
            textures.put((Object)type, (Object)vanilla);
        }
    }

    public static enum RandomTextureType {
        COW,
        PIG,
        CHICKEN,
        CHICK;

    }
}

