/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.betteranimals;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.ocelot.betteranimals.client.ReplacementHandler;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterAnimalsConfig {
    public static final Logger LOG = LogManager.getLogger();
    private static final Type TYPE = new TypeToken<Map<String, Map<String, Boolean>>>(){}.getType();

    public static OverridesConfiguration load(File location) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonReader reader = new JsonReader((Reader)new FileReader(location));
            OverridesConfiguration cfg = new OverridesConfiguration((Map)gson.fromJson(reader, TYPE));
            reader.close();
            return cfg;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            System.out.println("Misconfigured configuration in file: " + location.getAbsolutePath());
            throw e;
        }
        return null;
    }

    public static void genDefault(File location) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap configMap = new HashMap();
        ReplacementHandler.replaceDefs.values().forEach(m -> m.keySet().forEach(pair -> {
            configMap.putIfAbsent(pair.getLeft(), new HashMap());
            ((Map)configMap.get(pair.getLeft())).put(pair.getRight(), true);
        }));
        try (FileWriter writer = new FileWriter(location);){
            gson.toJson(configMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class OverridesConfiguration {
        public final Map<String, Map<String, Boolean>> mods;

        public OverridesConfiguration(Map<String, Map<String, Boolean>> mods) {
            this.mods = mods;
        }
    }
}

