/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blood_particles;

import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="blood_particles")
public class ModEntityEvents {
    private static Logger log = LogManager.getLogger(ModEntityEvents.class);
    private static final IParticleData ZOMBIE_PIGMAN_PARTICLE_DATA = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196785_ft.func_176223_P());
    private static final IParticleData PHANTOM_PARTICLE_DATA = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196815_gq.func_176223_P());
    private static final IParticleData BLAZE_PARTICLE_DATA = ParticleTypes.field_197631_x;
    private static final IParticleData SLIME_PARTICLE_DATA = ParticleTypes.field_197592_C;
    private static final IParticleData MAGMA_CUBE_PARTICLE_DATA = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196814_hQ.func_176223_P());
    private static final IParticleData ENDER_PARTICLE_DATA = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196848_iM.func_176223_P());
    private static final IParticleData DEFAULT_PARTICLE_DATA = new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150451_bX.func_176223_P());
    private static Random rand = new Random();

    @SubscribeEvent
    public static void onLivingAttacked(LivingAttackEvent event) {
        int numParticles;
        if (!ModEntityEvents.isValidDamageSource(event.getSource())) {
            return;
        }
        if (FMLEnvironment.dist != Dist.CLIENT || !event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        float amount = event.getAmount();
        DamageSource source = event.getSource();
        switch (source.field_76373_n) {
            case "arrow": {
                numParticles = 5 + (int)(amount * 15.0f);
                break;
            }
            case "trident": {
                numParticles = 5 + (int)(amount * 15.0f);
                break;
            }
            case "player": {
                PlayerEntity player = (PlayerEntity)source.func_76346_g();
                ItemStack weapon = player.func_184614_ca();
                if (!weapon.func_190926_b()) {
                    Item item = weapon.func_77973_b();
                    float itemAttackDamage = item instanceof ToolItem ? ((ToolItem)item).field_77865_bY : (item instanceof SwordItem ? ((SwordItem)item).func_200894_d() : 1.0f);
                    numParticles = 5 + (int)((amount + itemAttackDamage) * 15.0f);
                    break;
                }
            }
            default: {
                numParticles = amount == 0.0f ? 20 : 5 + (int)(amount * 15.0f);
            }
        }
        if (entity instanceof AbstractSkeletonEntity) {
            return;
        }
        IParticleData particleData = entity instanceof ZombiePigmanEntity ? ZOMBIE_PIGMAN_PARTICLE_DATA : (entity instanceof PhantomEntity ? PHANTOM_PARTICLE_DATA : (entity instanceof BlazeEntity ? BLAZE_PARTICLE_DATA : (entity instanceof MagmaCubeEntity ? MAGMA_CUBE_PARTICLE_DATA : (entity instanceof SlimeEntity ? SLIME_PARTICLE_DATA : (entity instanceof EndermanEntity || entity instanceof EnderDragonEntity ? ENDER_PARTICLE_DATA : DEFAULT_PARTICLE_DATA)))));
        WorldRenderer worldRenderer = Minecraft.func_71410_x().field_71438_f;
        double x = entity.field_70165_t;
        double y = entity.field_70163_u + (double)entity.func_213302_cg() / 1.5;
        double z = entity.field_70161_v;
        for (int i = 0; i < numParticles; ++i) {
            worldRenderer.func_195461_a(particleData, false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static double randomOffset() {
        if (rand.nextBoolean()) {
            return rand.nextDouble() - 1.5;
        }
        return rand.nextDouble() + 0.5;
    }

    private static boolean isValidDamageSource(DamageSource source) {
        String damageType = source.field_76373_n;
        return source == DamageSource.field_76379_h || source == DamageSource.field_191552_t || source == DamageSource.field_76377_j || source.func_76352_a() || damageType.equalsIgnoreCase("player") || damageType.equalsIgnoreCase("mob") || damageType.equalsIgnoreCase("thorns");
    }

    private static String damageSourceToString(DamageSource source) {
        if (source == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(source.field_76373_n).append(" {");
        if (source.func_76345_d() != 0.0f) {
            sb.append(" hunger damage = ").append(source.func_76345_d()).append(',');
        }
        if (source.func_76347_k()) {
            sb.append(" fire damage,");
        }
        if (source.func_76352_a()) {
            sb.append(" projectile,");
        }
        if (source.func_76350_n()) {
            sb.append(" difficulty scaled,");
        }
        if (source.func_82725_o()) {
            sb.append(" magic,");
        }
        if (source.func_94541_c()) {
            sb.append(" explosion,");
        }
        if (source.func_151517_h()) {
            sb.append(" absolute damage,");
        }
        if (source.func_76363_c()) {
            sb.append(" unblockable,");
        }
        if (source.func_76357_e()) {
            sb.append(" can harm creative players,");
        }
        if (source.func_76364_f() != null) {
            sb.append(" immediate source = ").append(source.func_76364_f().func_200600_R().getRegistryName()).append(',');
        }
        if (source.func_76346_g() != null) {
            sb.append(" true source = ").append(source.func_76346_g().func_200600_R().getRegistryName()).append(',');
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ' ');
        }
        sb.append('}');
        return sb.toString();
    }
}

