/*
 * Decompiled with CFR 0.152.
 */
package assets.blood.client.core;

import assets.blood.common.BloodParticles;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import cpw.mods.fml.common.ModContainer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;

public class EntityBlacklist {
    public ArrayList<Class<? extends EntityLivingBase>> blacklist = new ArrayList();
    private Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();

    public boolean isEntityBlacklisted(EntityLivingBase entity) {
        return this.blacklist.contains(entity.getClass());
    }

    public boolean isEntityBlacklisted(Class<? extends EntityLivingBase> entity) {
        return this.blacklist.contains(entity);
    }

    public void blacklistEntity(Class<? extends EntityLivingBase> entity) {
        if (!this.isEntityBlacklisted(entity)) {
            this.blacklist.add(entity);
            BloodParticles.logger.info("Blacklisted " + entity.getName());
        }
    }

    public void searchModForBlacklist(ModContainer mod) {
        InputStream stream;
        BloodParticles.logger.info("Searching mod \"" + mod.getName() + "\" for blacklists...");
        InputStream inputStream = stream = mod.getMod() != null ? mod.getMod().getClass().getResourceAsStream("/romejanic/blood/blacklist.json") : null;
        if (stream != null) {
            try {
                BloodParticles.logger.info("[" + mod.getName() + "]" + " Blacklist found!");
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
                reader.setLenient(true);
                BlacklistInformation info = (BlacklistInformation)this.gson.fromJson(reader, BlacklistInformation.class);
                for (Class<? extends EntityLivingBase> clazz : info.getEntityClasses()) {
                    this.blacklistEntity(clazz);
                }
                reader.close();
            }
            catch (Exception e) {
                BloodParticles.logger.error("[" + mod.getName() + "]" + " Cannot read blacklist information!", (Throwable)e);
            }
        } else {
            BloodParticles.logger.info("[" + mod.getName() + "]" + " No blacklist information found");
        }
    }

    public class BlacklistInformation {
        @SerializedName(value="classes")
        private String[] classes;

        public String[] getClasses() {
            return this.classes;
        }

        public Class<? extends EntityLivingBase>[] getEntityClasses() {
            ArrayList classes = new ArrayList();
            for (String clazz : this.getClasses()) {
                try {
                    Class<?> c = Class.forName(clazz);
                    if (!EntityLivingBase.class.isAssignableFrom(c)) {
                        BloodParticles.logger.error(c.getName() + " is not an instance of EntityLivingBase!");
                        continue;
                    }
                    classes.add(c);
                }
                catch (Throwable e) {
                    BloodParticles.logger.error("Cannot load entity class: " + clazz + " (" + e.getClass().getSimpleName() + ")");
                }
            }
            return classes.toArray(new Class[0]);
        }
    }
}

