/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.primalcore;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import nmd.primal.core.api.PrimalAPI;
import nmd.primal.core.common.blocks.lighting.Torch;
import nmd.primal.core.common.init.ModConfig;

public class PrimalCeilingTorch
extends Torch {
    protected static final AxisAlignedBB CEILING_AABB = new AxisAlignedBB((double)0.4f, 0.3999999761581421, (double)0.4f, (double)0.6f, 1.0, (double)0.6f);

    public PrimalCeilingTorch(float light, boolean rateFlag, boolean canExpire, SoundType sound) {
        super(light, rateFlag ? ModConfig.Flammability.TORCH_ENTITY_BURN : 60, canExpire, sound);
    }

    public boolean doPickup(World world, BlockPos pos, IBlockState state, EnumFacing facing, EntityPlayer player, EnumHand hand) {
        ItemStack stack = new ItemStack(this.func_180660_a(state, RANDOM, 0));
        if (world.func_175698_g(pos)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
            return true;
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CEILING_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private static boolean canPlaceOn(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return PrimalCeilingTorch.canPlaceAt(world, pos, EnumFacing.DOWN);
    }

    public static boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos oppositePos = pos.func_177972_a(facing.func_176734_d());
        IBlockState oppositeState = world.func_180495_p(oppositePos);
        Block block = oppositeState.func_177230_c();
        BlockFaceShape bfs = oppositeState.func_193401_d((IBlockAccess)world, oppositePos, facing);
        if (facing.equals((Object)EnumFacing.UP) && PrimalCeilingTorch.canPlaceOn(world, oppositePos)) {
            return true;
        }
        if (facing != EnumFacing.UP) {
            return !PrimalCeilingTorch.func_193382_c((Block)block) && bfs == BlockFaceShape.SOLID;
        }
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta == 1));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.func_176593_f(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.func_176592_e(world, pos, state);
    }

    protected boolean func_176592_e(World world, BlockPos pos, IBlockState state) {
        if (!this.func_176593_f(world, pos, state)) {
            return true;
        }
        EnumFacing facing = EnumFacing.DOWN;
        EnumFacing.Axis axis = facing.func_176740_k();
        EnumFacing oppositeFacing = facing.func_176734_d();
        BlockPos oppositePos = pos.func_177972_a(oppositeFacing);
        boolean flag = false;
        if (axis.func_176722_c() && world.func_180495_p(oppositePos).func_193401_d((IBlockAccess)world, oppositePos, facing) != BlockFaceShape.SOLID) {
            flag = true;
        } else if (axis.func_176720_b() && !PrimalCeilingTorch.canPlaceOn(world, oppositePos)) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean func_176593_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && PrimalCeilingTorch.canPlaceAt(world, pos, EnumFacing.DOWN)) {
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isLit((IBlockAccess)world, pos, state)) {
            EnumParticleTypes smoke = world.func_175727_C(pos) ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL;
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d2 = (double)pos.func_177956_o() + 0.3;
            double d3 = (double)pos.func_177952_p() + 0.5;
            world.func_175688_a(smoke, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static class Nether
    extends PrimalCeilingTorch {
        public Nether(float light, boolean rateFlag, boolean canExpire, SoundType sound) {
            super(light, rateFlag, canExpire, sound);
        }

        public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
            return new ItemStack(PrimalAPI.Blocks.TORCH_NETHER);
        }

        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return (Boolean)state.func_177229_b((IProperty)LIT) != false ? PrimalAPI.Items.TORCH_NETHER_LIT : Item.func_150898_a((Block)PrimalAPI.Blocks.TORCH_NETHER);
        }

        public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
            return new ItemStack(PrimalAPI.Blocks.TORCH_NETHER);
        }
    }

    public static class Wood
    extends PrimalCeilingTorch {
        public Wood(float light, boolean rateFlag, boolean canExpire, SoundType sound) {
            super(light, rateFlag, canExpire, sound);
        }

        public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
            return new ItemStack(PrimalAPI.Blocks.TORCH_WOOD);
        }

        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Item.func_150898_a((Block)PrimalAPI.Blocks.TORCH_WOOD);
        }

        public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
            return new ItemStack(PrimalAPI.Blocks.TORCH_WOOD);
        }
    }
}

