/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.vanilla;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCeilingTorch
extends Block {
    protected static final AxisAlignedBB CEILING_AABB = new AxisAlignedBB((double)0.4f, 0.3999999761581421, (double)0.4f, (double)0.6f, 1.0, (double)0.6f);

    public BlockCeilingTorch() {
        super(Material.field_151594_q);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.0f);
        this.func_149715_a(0.9375f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CEILING_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private static boolean canPlaceOn(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return BlockCeilingTorch.canPlaceAt(world, pos, EnumFacing.DOWN);
    }

    public static boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos oppositePos = pos.func_177972_a(facing.func_176734_d());
        IBlockState oppositeState = world.func_180495_p(oppositePos);
        Block block = oppositeState.func_177230_c();
        BlockFaceShape bfs = oppositeState.func_193401_d((IBlockAccess)world, oppositePos, facing);
        if (facing.equals((Object)EnumFacing.UP) && BlockCeilingTorch.canPlaceOn(world, oppositePos)) {
            return true;
        }
        if (facing != EnumFacing.UP) {
            return !BlockCeilingTorch.func_193382_c((Block)block) && bfs == BlockFaceShape.SOLID;
        }
        return false;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.checkForDrop(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.onNeighborChangeInternal(world, pos, state);
    }

    protected boolean onNeighborChangeInternal(World world, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(world, pos, state)) {
            return true;
        }
        EnumFacing facing = EnumFacing.DOWN;
        EnumFacing.Axis axis = facing.func_176740_k();
        EnumFacing oppositeFacing = facing.func_176734_d();
        BlockPos oppositePos = pos.func_177972_a(oppositeFacing);
        boolean flag = false;
        if (axis.func_176722_c() && world.func_180495_p(oppositePos).func_193401_d((IBlockAccess)world, oppositePos, facing) != BlockFaceShape.SOLID) {
            flag = true;
        } else if (axis.func_176720_b() && !BlockCeilingTorch.canPlaceOn(world, oppositePos)) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && BlockCeilingTorch.canPlaceAt(world, pos, EnumFacing.DOWN)) {
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150478_aa);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Blocks.field_150478_aa);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.7;
        double z = (double)pos.func_177952_p() + 0.5;
        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y - 0.25, z, 0.0, 0.0, 0.0, new int[0]);
        world.func_175688_a(EnumParticleTypes.FLAME, x, y - 0.25, z, 0.0, 0.0, 0.0, new int[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

