/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.vanilla;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.BlockCeilingTorch;
import bl4ckscor3.mod.ceilingtorch.compat.vanilla.VanillaCompat;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstoneCeilingTorch
extends BlockCeilingTorch {
    private static final Map<World, List<Toggle>> toggles = new WeakHashMap<World, List<Toggle>>();
    private final boolean isOn;

    protected BlockRedstoneCeilingTorch(boolean isOn) {
        this.isOn = isOn;
        this.func_149715_a(isOn ? 0.5f : 0.0f);
    }

    private boolean isBurnedOut(World world, BlockPos pos, boolean turnOff) {
        if (!toggles.containsKey(world)) {
            toggles.put(world, Lists.newArrayList());
        }
        List<Toggle> list = toggles.get(world);
        if (turnOff) {
            list.add(new Toggle(pos, world.func_82737_E()));
        }
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            Toggle toggle = list.get(j);
            if (!toggle.pos.equals((Object)pos) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    public int func_149738_a(World world) {
        return 2;
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.isOn) {
            for (EnumFacing facing : EnumFacing.values()) {
                world.func_175685_c(pos.func_177972_a(facing), (Block)this, false);
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (this.isOn) {
            for (EnumFacing facing : EnumFacing.values()) {
                world.func_175685_c(pos.func_177972_a(facing), (Block)this, false);
            }
        }
    }

    public int func_180656_a(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        return this.isOn && EnumFacing.DOWN != side ? 15 : 0;
    }

    private boolean shouldBeOff(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = EnumFacing.DOWN.func_176734_d();
        return world.func_175709_b(pos.func_177972_a(facing), facing);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean flag = this.shouldBeOff(world, pos, state);
        List<Toggle> list = toggles.get(world);
        while (list != null && !list.isEmpty() && world.func_82737_E() - list.get((int)0).time > 60L) {
            list.remove(0);
        }
        if (this.isOn) {
            if (flag) {
                world.func_180501_a(pos, VanillaCompat.UNLIT_REDSTONE_TORCH.func_176223_P(), 3);
                if (this.isBurnedOut(world, pos, true)) {
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
                    for (int i = 0; i < 5; ++i) {
                        double x = (double)pos.func_177958_n() + rand.nextDouble() * 0.6 + 0.2;
                        double y = (double)pos.func_177956_o() + rand.nextDouble() * 0.6 + 0.2;
                        double z = (double)pos.func_177952_p() + rand.nextDouble() * 0.6 + 0.2;
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                    }
                    world.func_175684_a(pos, world.func_180495_p(pos).func_177230_c(), 160);
                }
            }
        } else if (!flag && !this.isBurnedOut(world, pos, false)) {
            world.func_180501_a(pos, VanillaCompat.REDSTONE_TORCH.func_176223_P(), 3);
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.onNeighborChangeInternal(world, pos, state) && this.isOn == this.shouldBeOff(world, pos, state)) {
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
    }

    public int func_176211_b(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? state.func_185911_a(access, pos, side) : 0;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150429_aA);
    }

    @Override
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Blocks.field_150429_aA);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isOn) {
            double x = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double y = (double)pos.func_177956_o() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double z = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            EnumFacing facing = EnumFacing.DOWN;
            if (facing.func_176740_k().func_176722_c()) {
                EnumFacing oppositeFacing = facing.func_176734_d();
                x += 0.27 * (double)oppositeFacing.func_82601_c();
                y += 0.22;
                z += 0.27 * (double)oppositeFacing.func_82599_e();
            }
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y - (facing == EnumFacing.DOWN ? 0.25 : 0.0), z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_149667_c(Block other) {
        return other == VanillaCompat.UNLIT_REDSTONE_TORCH || other == VanillaCompat.REDSTONE_TORCH;
    }

    static class Toggle {
        BlockPos pos;
        long time;

        public Toggle(BlockPos pos, long time) {
            this.pos = pos;
            this.time = time;
        }
    }
}

