/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.magicaltorches;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import de.geheimagentnr1.magical_torches.elements.blocks.ModBlocks;
import de.geheimagentnr1.magical_torches.elements.capabilities.ModCapabilities;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.ISpawnBlockFactory;
import de.geheimagentnr1.magical_torches.elements.capabilities.spawn_blocking.SpawnBlockingCapability;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class SpawnBlockingCeilingTorchBlock
extends CeilingTorchBlock {
    private final ISpawnBlockFactory spawnBlockFactory;
    private final String name;
    private final VoxelShape shape;

    public SpawnBlockingCeilingTorchBlock(Block.Properties properties, String spawnBlockRegistryName, ISpawnBlockFactory spawnBlockFactory) {
        super(properties);
        this.spawnBlockFactory = spawnBlockFactory;
        SpawnBlockingCapability.registerSpawnBlocker((ResourceLocation)new ResourceLocation("ceilingtorch", spawnBlockRegistryName), (ISpawnBlockFactory)this.spawnBlockFactory);
        switch (this.name = spawnBlockRegistryName) {
            case "small_torch": {
                this.shape = Block.func_208617_a((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
                break;
            }
            case "medium_torch": {
                this.shape = Block.func_208617_a((double)6.5, (double)5.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
                break;
            }
            case "grand_torch": {
                this.shape = Block.func_208617_a((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
                break;
            }
            case "mega_torch": {
                this.shape = Block.func_208617_a((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
                break;
            }
            default: {
                this.shape = VoxelShapes.func_197868_b();
            }
        }
    }

    @Override
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.shape;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public ResourceLocation func_220068_i() {
        switch (this.name) {
            case "small_torch": {
                return ModBlocks.SMALL_TORCH.func_220068_i();
            }
            case "medium_torch": {
                return ModBlocks.MEDIUM_TORCH.func_220068_i();
            }
            case "grand_torch": {
                return ModBlocks.GRAND_TORCH.func_220068_i();
            }
            case "mega_torch": {
                return ModBlocks.MEGA_TORCH.func_220068_i();
            }
        }
        return super.func_220068_i();
    }

    @Override
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        switch (this.name) {
            case "small_torch": {
                return new ItemStack((IItemProvider)ModBlocks.SMALL_TORCH);
            }
            case "medium_torch": {
                return new ItemStack((IItemProvider)ModBlocks.MEDIUM_TORCH);
            }
            case "grand_torch": {
                return new ItemStack((IItemProvider)ModBlocks.GRAND_TORCH);
            }
            case "mega_torch": {
                return new ItemStack((IItemProvider)ModBlocks.MEGA_TORCH);
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.getCapability(ModCapabilities.SPAWN_BLOCKING).ifPresent(capability -> capability.addSpawnBlocker(this.spawnBlockFactory.buildSpawnBlocker(pos)));
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.getCapability(ModCapabilities.SPAWN_BLOCKING).ifPresent(capability -> capability.removeSpawnBlocker(this.spawnBlockFactory.buildSpawnBlocker(pos)));
    }
}

