/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.modernity;

import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.PlaceHandler;
import bl4ckscor3.mod.ceilingtorch.compat.modernity.ModernityCeilingTorchBlock;
import bl4ckscor3.mod.ceilingtorch.compat.modernity.ModernityExtinguishableCeilingTorchBlock;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import modernity.common.block.MDBlockStateProperties;
import modernity.common.block.MDBuildingBlocks;
import modernity.common.block.fluid.WaterlogType;
import modernity.common.block.fluid.WaterloggedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModernityCompat
implements ICeilingTorchCompat {
    public static Block extinguishedAnthraciteCeilingTorch;
    public static Block anthraciteCeilingTorch;
    public static Block luminositeCeilingTorch;
    private Map<ResourceLocation, Block> placeEntries;

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        extinguishedAnthraciteCeilingTorch = (Block)new ModernityCeilingTorchBlock(Block.Properties.func_200949_a((Material)Material.field_151594_q, (MaterialColor)MaterialColor.field_151666_j).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185848_a), false){

            public ResourceLocation func_220068_i() {
                return MDBuildingBlocks.EXTINGUISHED_ANTHRACITE_TORCH.func_220068_i();
            }

            public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
                return new ItemStack((IItemProvider)MDBuildingBlocks.EXTINGUISHED_ANTHRACITE_TORCH);
            }
        }.setRegistryName(new ResourceLocation("ceilingtorch", "modernity_extinguished_anthracite_torch"));
        event.getRegistry().register((IForgeRegistryEntry)extinguishedAnthraciteCeilingTorch);
        anthraciteCeilingTorch = (Block)new ModernityExtinguishableCeilingTorchBlock(Block.Properties.func_200949_a((Material)Material.field_151594_q, (MaterialColor)MaterialColor.field_151666_j).func_200942_a().func_200943_b(0.0f).func_200951_a(15).func_200947_a(SoundType.field_185848_a), true, extinguishedAnthraciteCeilingTorch){

            public ResourceLocation func_220068_i() {
                return MDBuildingBlocks.ANTHRACITE_TORCH.func_220068_i();
            }

            public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
                return new ItemStack((IItemProvider)MDBuildingBlocks.ANTHRACITE_TORCH);
            }
        }.setRegistryName(new ResourceLocation("ceilingtorch", "modernity_anthracite_torch"));
        event.getRegistry().register((IForgeRegistryEntry)anthraciteCeilingTorch);
        luminositeCeilingTorch = (Block)new ModernityCeilingTorchBlock(Block.Properties.func_200949_a((Material)Material.field_151594_q, (MaterialColor)MaterialColor.field_151666_j).func_200942_a().func_200943_b(0.0f).func_200951_a(15).func_200947_a(SoundType.field_185848_a), false){

            public ResourceLocation func_220068_i() {
                return MDBuildingBlocks.LUMINOSITE_TORCH.func_220068_i();
            }

            public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
                return new ItemStack((IItemProvider)MDBuildingBlocks.LUMINOSITE_TORCH);
            }
        }.setRegistryName(new ResourceLocation("ceilingtorch", "modernity_luminosite_torch"));
        event.getRegistry().register((IForgeRegistryEntry)luminositeCeilingTorch);
    }

    @Override
    public Map<ResourceLocation, Block> getPlaceEntries() {
        if (this.placeEntries == null) {
            this.placeEntries = ImmutableMap.of((Object)MDBuildingBlocks.EXTINGUISHED_ANTHRACITE_TORCH.getRegistryName(), (Object)extinguishedAnthraciteCeilingTorch, (Object)MDBuildingBlocks.ANTHRACITE_TORCH.getRegistryName(), (Object)anthraciteCeilingTorch, (Object)MDBuildingBlocks.LUMINOSITE_TORCH.getRegistryName(), (Object)luminositeCeilingTorch);
        }
        return this.placeEntries;
    }

    public static boolean handlePlacement(ICeilingTorchCompat compat, PlayerInteractEvent.RightClickBlock event, ItemStack held, Block block, World world, BlockPos pos, BlockPos placeAt, Direction face) {
        boolean water;
        IFluidState fluidState = world.func_204610_c(placeAt);
        boolean air = world.func_175623_d(placeAt);
        WaterlogType waterlogType = WaterlogType.getType((IFluidState)fluidState);
        boolean bl = water = waterlogType != WaterlogType.NONE;
        if (!air && !water) {
            return false;
        }
        BlockState state = compat.getStateToPlace(held, block);
        if (block instanceof WaterloggedBlock) {
            state = (BlockState)state.func_206870_a((IProperty)MDBlockStateProperties.WATERLOGGED, (Comparable)waterlogType);
        } else if (block instanceof IWaterLoggable) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(water));
        }
        return PlaceHandler.placeTorch(event, held, block, pos, placeAt, world, state);
    }
}

