/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.torcherino;

import bl4ckscor3.mod.ceilingtorch.ICeilingTorchCompat;
import bl4ckscor3.mod.ceilingtorch.compat.torcherino.CeilingTorcherinoBlock;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import torcherino.api.TorcherinoAPI;

public class TorcherinoCompat
implements ICeilingTorchCompat {
    public static final List<CeilingTorcherinoBlock> CEILING_TORCHERINOS = new ArrayList<CeilingTorcherinoBlock>();
    private Map<ResourceLocation, Block> placeEntries;

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        TorcherinoAPI.INSTANCE.getTiers().keySet().forEach(tierId -> {
            if (tierId.func_110624_b().equals("torcherino")) {
                ResourceLocation flameId = TorcherinoCompat.loc("torcherino", tierId, "flame");
                CeilingTorcherinoBlock block = (CeilingTorcherinoBlock)new CeilingTorcherinoBlock((ResourceLocation)tierId, flameId).setRegistryName(TorcherinoCompat.loc("ceilingtorch", "torcherino_", tierId, "torcherino"));
                CEILING_TORCHERINOS.add(block);
                event.getRegistry().register((IForgeRegistryEntry)block);
            }
        });
    }

    @Override
    public Map<ResourceLocation, Block> getPlaceEntries() {
        if (this.placeEntries == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (CeilingTorcherinoBlock ceilingTorcherino : CEILING_TORCHERINOS) {
                Block torcherino = ceilingTorcherino.getVanillaTorcherino();
                if (torcherino == Blocks.field_150350_a) continue;
                builder.put((Object)torcherino.getRegistryName(), (Object)ceilingTorcherino);
            }
            this.placeEntries = builder.build();
        }
        return this.placeEntries;
    }

    public static ResourceLocation loc(String modId, ResourceLocation tierId, String type) {
        return TorcherinoCompat.loc(modId, "", tierId, type);
    }

    public static ResourceLocation loc(String modId, String prefix, ResourceLocation tierId, String type) {
        if (tierId.func_110623_a().equals("normal")) {
            return new ResourceLocation(modId, prefix + type);
        }
        return new ResourceLocation(modId, prefix + tierId.func_110623_a() + "_" + type);
    }
}

