/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.ceilingtorch.compat.upgradeaquatic;

import bl4ckscor3.mod.ceilingtorch.compat.vanilla.CeilingTorchBlock;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockJellyTorch;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JellyCeilingTorchBlock
extends CeilingTorchBlock
implements IWaterLoggable {
    private final BlockJellyTorch.JellyTorchType torchType;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public JellyCeilingTorchBlock(Block.Properties properties, BlockJellyTorch.JellyTorchType torchType) {
        super(properties);
        this.torchType = torchType;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        double xOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double yOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double zOffset = rand.nextBoolean() ? -(Math.random() * 0.1) : Math.random() * 0.1;
        double d0 = (double)pos.func_177958_n() + 0.5 + xOffset;
        double d1 = (double)pos.func_177956_o() + 0.5 + yOffset;
        double d2 = (double)pos.func_177952_p() + 0.5 + zOffset;
        world.func_195594_a((IParticleData)BlockJellyTorch.getTorchParticleType((BlockJellyTorch.JellyTorchType)this.torchType), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, state, world, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        IFluidState fluidState = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        return (BlockState)super.func_196258_a(ctx).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, IFluidState fluidState) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
            }
            return true;
        }
        return false;
    }

    public ResourceLocation func_220068_i() {
        switch (this.torchType) {
            default: {
                return UABlocks.JELLY_TORCH_PINK.func_220068_i();
            }
            case PURPLE: {
                return UABlocks.JELLY_TORCH_PURPLE.func_220068_i();
            }
            case BLUE: {
                return UABlocks.JELLY_TORCH_BLUE.func_220068_i();
            }
            case GREEN: {
                return UABlocks.JELLY_TORCH_GREEN.func_220068_i();
            }
            case YELLOW: {
                return UABlocks.JELLY_TORCH_YELLOW.func_220068_i();
            }
            case ORANGE: {
                return UABlocks.JELLY_TORCH_ORANGE.func_220068_i();
            }
            case RED: {
                return UABlocks.JELLY_TORCH_RED.func_220068_i();
            }
            case WHITE: 
        }
        return UABlocks.JELLY_TORCH_WHITE.func_220068_i();
    }

    @Override
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        switch (this.torchType) {
            default: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_PINK);
            }
            case PURPLE: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_PURPLE);
            }
            case BLUE: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_BLUE);
            }
            case GREEN: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_GREEN);
            }
            case YELLOW: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_YELLOW);
            }
            case ORANGE: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_ORANGE);
            }
            case RED: {
                return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_RED);
            }
            case WHITE: 
        }
        return new ItemStack((IItemProvider)UABlocks.JELLY_TORCH_WHITE);
    }
}

