/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cherishedworlds.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiListWorldSelection;
import net.minecraft.client.gui.GuiListWorldSelectionEntry;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import top.theillusivec4.cherishedworlds.CherishedWorlds;
import top.theillusivec4.cherishedworlds.util.FavoriteWorldsList;
import top.theillusivec4.cherishedworlds.util.ReflectionAccessor;

public class EventHandlerGui {
    private static final ResourceLocation STAR_ICON = new ResourceLocation("cherishedworlds", "textures/gui/staricon.png");
    private static final ResourceLocation EMPTY_STAR_ICON = new ResourceLocation("cherishedworlds", "textures/gui/emptystaricon.png");

    @SubscribeEvent
    public void onGuiDrawScreen(GuiScreenEvent.DrawScreenEvent.Post evt) {
        GuiWorldSelection worldSelect;
        GuiListWorldSelection selectionList;
        GuiScreen gui = evt.getGui();
        if (gui instanceof GuiWorldSelection && (selectionList = ReflectionAccessor.getSelectionList(worldSelect = (GuiWorldSelection)gui)) != null) {
            for (int i = 0; i < selectionList.func_195074_b().size(); ++i) {
                WorldSummary summary;
                GuiListWorldSelectionEntry entry = (GuiListWorldSelectionEntry)selectionList.func_195074_b().get(i);
                if (entry == null || (summary = ReflectionAccessor.getWorldSummary(entry)) == null) continue;
                boolean isFavorite = FavoriteWorldsList.isFavorite(summary.func_75786_a());
                ResourceLocation icon = isFavorite ? STAR_ICON : EMPTY_STAR_ICON;
                int top = selectionList.field_148153_b + 15 + selectionList.field_148149_f * i - selectionList.func_148148_g();
                int x = evt.getGui().field_146294_l / 2 - 148;
                if (top < selectionList.field_148154_c - 8 && top > selectionList.field_148153_b) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
                    Gui.func_146110_a((int)x, (int)top, (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
                }
                int mouseX = evt.getMouseX();
                int mouseY = evt.getMouseY();
                if (mouseY < top || mouseY > top + 9 || mouseX < x || mouseX > x + 9) continue;
                String s = new TextComponentTranslation("selectWorld.cherishedworlds." + (isFavorite ? "unfavorite" : "favorite"), new Object[0]).func_150254_d();
                GuiUtils.drawHoveringText((List)Lists.newArrayList((Object[])new String[]{s}), (int)mouseX, (int)mouseY, (int)gui.field_146294_l, (int)gui.field_146295_m, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            }
        }
    }

    @SubscribeEvent
    public void onGuiMouseClick(GuiScreenEvent.MouseClickedEvent.Pre evt) {
        GuiWorldSelection worldSelect;
        GuiListWorldSelection selectionList;
        GuiScreen gui = evt.getGui();
        if (gui instanceof GuiWorldSelection && (selectionList = ReflectionAccessor.getSelectionList(worldSelect = (GuiWorldSelection)gui)) != null) {
            for (int i = 0; i < selectionList.func_195074_b().size(); ++i) {
                WorldSummary summary;
                GuiListWorldSelectionEntry entry = (GuiListWorldSelectionEntry)selectionList.func_195074_b().get(i);
                if (entry == null || (summary = ReflectionAccessor.getWorldSummary(entry)) == null) continue;
                boolean isFavorite = FavoriteWorldsList.isFavorite(summary.func_75786_a());
                int top = selectionList.field_148153_b + 15 + selectionList.field_148149_f * i - selectionList.func_148148_g();
                int x = evt.getGui().field_146294_l / 2 - 148;
                double mouseX = evt.getMouseX();
                double mouseY = evt.getMouseY();
                if (!(mouseY >= (double)top) || !(mouseY <= (double)(top + 9)) || !(mouseX >= (double)x) || !(mouseX <= (double)(x + 9))) continue;
                String s = summary.func_75786_a();
                if (isFavorite) {
                    FavoriteWorldsList.removeFavorite(s);
                } else {
                    FavoriteWorldsList.addFavorite(s);
                }
                FavoriteWorldsList.saveFavoritesList();
                EventHandlerGui.refreshList(selectionList);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onGuiMouseClicked(GuiScreenEvent.MouseClickedEvent.Post evt) {
        GuiListWorldSelectionEntry entry;
        GuiWorldSelection worldSelect;
        GuiListWorldSelection selectionList;
        GuiScreen gui = evt.getGui();
        if (gui instanceof GuiWorldSelection && (selectionList = ReflectionAccessor.getSelectionList(worldSelect = (GuiWorldSelection)gui)) != null && (entry = selectionList.func_186794_f()) != null) {
            boolean isFavorite;
            List<GuiButton> buttonList = ReflectionAccessor.getButtonList(gui);
            WorldSummary summary = ReflectionAccessor.getWorldSummary(entry);
            boolean bl = isFavorite = summary != null && FavoriteWorldsList.isFavorite(summary.func_75786_a());
            if (buttonList != null && !buttonList.isEmpty() && buttonList.size() >= 4) {
                buttonList.get((int)3).field_146124_l = !isFavorite;
            }
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post evt) {
        GuiScreen gui = evt.getGui();
        if (gui instanceof GuiWorldSelection) {
            GuiWorldSelection worldSelect = (GuiWorldSelection)gui;
            GuiListWorldSelection selectionList = ReflectionAccessor.getSelectionList(worldSelect);
            GuiTextField textField = ReflectionAccessor.getTextField(worldSelect);
            if (selectionList != null) {
                FavoriteWorldsList.loadFavoritesList();
                textField.func_195609_a((i, s) -> EventHandlerGui.refreshList(selectionList, () -> s));
                EventHandlerGui.refreshList(selectionList);
            }
        }
    }

    private static void refreshList(GuiListWorldSelection listWorldSelection) {
        EventHandlerGui.refreshList(listWorldSelection, null);
    }

    private static void refreshList(GuiListWorldSelection listWorldSelection, Supplier<String> supplier) {
        GuiListWorldSelectionEntry entry;
        List list;
        Minecraft mc = Minecraft.func_71410_x();
        ISaveFormat isaveformat = mc.func_71359_d();
        try {
            list = isaveformat.func_75799_b();
        }
        catch (AnvilConverterException anvilconverterexception) {
            CherishedWorlds.LOGGER.error("Couldn't load level list", (Throwable)anvilconverterexception);
            mc.func_147108_a((GuiScreen)new GuiErrorScreen(I18n.func_135052_a((String)"selectWorld.unable_to_load", (Object[])new Object[0]), anvilconverterexception.getMessage()));
            return;
        }
        List<GuiListWorldSelectionEntry> entries = ReflectionAccessor.getWorldSelectionEntries(listWorldSelection);
        if (entries != null) {
            entries.clear();
            ListIterator iter = list.listIterator();
            ArrayList favorites = Lists.newArrayList();
            while (iter.hasNext()) {
                WorldSummary summ = (WorldSummary)iter.next();
                if (!FavoriteWorldsList.isFavorite(summ.func_75786_a())) continue;
                favorites.add(summ);
                iter.remove();
            }
            Collections.sort(favorites);
            Collections.sort(list);
            String s = supplier == null ? "" : supplier.get().toLowerCase(Locale.ROOT);
            for (WorldSummary worldsummary : favorites) {
                if (!s.isEmpty() && !worldsummary.func_75788_b().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.func_75786_a().toLowerCase(Locale.ROOT).contains(s)) continue;
                entries.add(new GuiListWorldSelectionEntry(listWorldSelection, worldsummary, mc.func_71359_d()));
            }
            for (WorldSummary worldsummary : list) {
                if (!s.isEmpty() && !worldsummary.func_75788_b().toLowerCase(Locale.ROOT).contains(s) && !worldsummary.func_75786_a().toLowerCase(Locale.ROOT).contains(s)) continue;
                entries.add(new GuiListWorldSelectionEntry(listWorldSelection, worldsummary, mc.func_71359_d()));
            }
        }
        if ((entry = listWorldSelection.func_186794_f()) != null) {
            boolean isFavorite;
            List<GuiButton> buttonList = ReflectionAccessor.getButtonList((GuiScreen)listWorldSelection.func_186796_g());
            WorldSummary summary = ReflectionAccessor.getWorldSummary(entry);
            boolean bl = isFavorite = summary != null && FavoriteWorldsList.isFavorite(summary.func_75786_a());
            if (buttonList != null && !buttonList.isEmpty() && buttonList.size() >= 4) {
                buttonList.get((int)3).field_146124_l = !isFavorite;
            }
        }
    }
}

