/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cherishedworlds.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import top.theillusivec4.cherishedworlds.CherishedWorlds;

public class FavoriteWorldsList {
    private static final Set<String> favorites = Sets.newHashSet();

    public static void loadFavoritesList() {
        try {
            favorites.clear();
            File file = new File(FMLPaths.CONFIGDIR.get().toString(), "cherishedworlds/favorites.dat");
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74797_a((File)file);
            if (nbttagcompound == null) {
                return;
            }
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("favorites", 8);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                favorites.add(nbttaglist.func_150307_f(i));
            }
        }
        catch (Exception exception) {
            CherishedWorlds.LOGGER.error("Couldn't load favorites list", (Throwable)exception);
        }
    }

    public static void saveFavoritesList() {
        try {
            NBTTagList nbttaglist = new NBTTagList();
            for (String s : favorites) {
                nbttaglist.add((INBTBase)new NBTTagString(s));
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("favorites", (INBTBase)nbttaglist);
            File file = new File(FMLPaths.CONFIGDIR.get().toString(), "cherishedworlds/favorites.dat");
            if (!file.exists()) {
                FileUtils.forceMkdirParent((File)file);
            }
            CompressedStreamTools.func_74793_a((NBTTagCompound)nbttagcompound, (File)file);
        }
        catch (Exception exception) {
            CherishedWorlds.LOGGER.error("Couldn't save favorites list", (Throwable)exception);
        }
    }

    public static boolean hasFavorite() {
        return !favorites.isEmpty();
    }

    public static boolean isFavorite(String fileName) {
        return favorites.contains(fileName);
    }

    public static void addFavorite(String name) {
        favorites.add(name);
    }

    public static void removeFavorite(String name) {
        favorites.remove(name);
    }
}

