/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.cherishedworlds.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import top.theillusivec4.cherishedworlds.CherishedWorlds;

public class FavoriteWorldsList {
    private static final Set<String> favorites = Sets.newHashSet();

    public static void loadFavoritesList() {
        try {
            favorites.clear();
            File file = new File(FMLPaths.CONFIGDIR.get().toString(), "cherishedworlds/favorites.dat");
            CompoundNBT compound = CompressedStreamTools.func_74797_a((File)file);
            if (compound == null) {
                return;
            }
            ListNBT list = compound.func_150295_c("favorites", 8);
            for (int i = 0; i < list.size(); ++i) {
                favorites.add(list.func_150307_f(i));
            }
        }
        catch (Exception exception) {
            CherishedWorlds.LOGGER.error("Couldn't load favorites list", (Throwable)exception);
        }
    }

    public static void saveFavoritesList() {
        try {
            ListNBT list = new ListNBT();
            for (String s : favorites) {
                list.add((Object)StringNBT.func_229705_a_((String)s));
            }
            CompoundNBT compound = new CompoundNBT();
            compound.func_218657_a("favorites", (INBT)list);
            File file = new File(FMLPaths.CONFIGDIR.get().toString(), "cherishedworlds/favorites.dat");
            if (!file.exists()) {
                FileUtils.forceMkdirParent((File)file);
            }
            CompressedStreamTools.func_74793_a((CompoundNBT)compound, (File)file);
        }
        catch (Exception exception) {
            CherishedWorlds.LOGGER.error("Couldn't save favorites list", (Throwable)exception);
        }
    }

    public static boolean isFavorite(String fileName) {
        return favorites.contains(fileName);
    }

    public static void addFavorite(String name) {
        favorites.add(name);
    }

    public static void removeFavorite(String name) {
        favorites.remove(name);
    }
}

