/*
 * Decompiled with CFR 0.152.
 */
package com.torquebolt.colorfularmor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class RecipeUtil {
    private static final Method DESERIALIZE_KEY = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192408_a", (Class[])new Class[]{JsonObject.class});
    private static final Method SHRINK = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_194134_a", (Class[])new Class[]{String[].class});
    private static final Method PATTERN_FROM_JSON = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192407_a", (Class[])new Class[]{JsonArray.class});
    private static final Method DESERIALIZE_INGREDIENTS = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192402_a", (Class[])new Class[]{String[].class, Map.class, Integer.TYPE, Integer.TYPE});

    public static ShapedPrimer parseShaped(JsonObject json) {
        try {
            Map key = (Map)DESERIALIZE_KEY.invoke(null, JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] pattern = (String[])SHRINK.invoke(null, PATTERN_FROM_JSON.invoke(null, JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int recipeWidth = pattern[0].length();
            int recipeHeight = pattern.length;
            NonNullList ingredients = (NonNullList)DESERIALIZE_INGREDIENTS.invoke(null, pattern, key, recipeWidth, recipeHeight);
            return new ShapedPrimer((NonNullList<Ingredient>)ingredients, recipeWidth, recipeHeight);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to parse shaped recipe", e);
        }
    }

    public static NonNullList<Ingredient> parseShapeless(JsonObject json) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (JsonElement element : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        return ingredients;
    }

    public static class ShapedPrimer {
        private final NonNullList<Ingredient> ingredients;
        private final int recipeWidth;
        private final int recipeHeight;

        public ShapedPrimer(NonNullList<Ingredient> ingredients, int recipeWidth, int recipeHeight) {
            this.ingredients = ingredients;
            this.recipeWidth = recipeWidth;
            this.recipeHeight = recipeHeight;
        }

        public NonNullList<Ingredient> getIngredients() {
            return this.ingredients;
        }

        public int getRecipeWidth() {
            return this.recipeWidth;
        }

        public int getRecipeHeight() {
            return this.recipeHeight;
        }
    }
}

