/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.comforts.client.ClientEventHandler;
import top.theillusivec4.comforts.client.renderer.HammockTileEntityRenderer;
import top.theillusivec4.comforts.client.renderer.SleepingBagTileEntityRenderer;
import top.theillusivec4.comforts.common.ComfortsConfig;
import top.theillusivec4.comforts.common.ComfortsRegistry;
import top.theillusivec4.comforts.common.CommonEventHandler;
import top.theillusivec4.comforts.common.block.HammockBlock;
import top.theillusivec4.comforts.common.block.RopeAndNailBlock;
import top.theillusivec4.comforts.common.block.SleepingBagBlock;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;
import top.theillusivec4.comforts.common.item.ComfortsBaseItem;
import top.theillusivec4.comforts.common.item.HammockItem;
import top.theillusivec4.comforts.common.item.SleepingBagItem;
import top.theillusivec4.comforts.common.network.ComfortsNetwork;
import top.theillusivec4.comforts.common.tileentity.HammockTileEntity;
import top.theillusivec4.comforts.common.tileentity.SleepingBagTileEntity;
import top.theillusivec4.comforts.data.ComfortsLootProvider;
import top.theillusivec4.comforts.integration.MorpheusIntegration;

@Mod(value="comforts")
public class Comforts {
    public static final String MODID = "comforts";
    public static final ItemGroup CREATIVE_TAB = new ItemGroup(-1, "comforts"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ComfortsRegistry.SLEEPING_BAGS.get(DyeColor.RED));
        }
    };
    public static final Logger LOGGER = LogManager.getLogger();

    public Comforts() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::gatherData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ComfortsConfig.serverSpec);
    }

    private void gatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        if (evt.includeServer()) {
            generator.func_200390_a((IDataProvider)new ComfortsLootProvider(generator));
        }
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        CapabilitySleepData.register();
        ComfortsNetwork.register();
        if (ModList.get().isLoaded("morpheus")) {
            MorpheusIntegration.register();
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> evt) {
            IForgeRegistry registry = evt.getRegistry();
            Arrays.stream(DyeColor.values()).forEach(color -> {
                SleepingBagBlock sleepingBag = new SleepingBagBlock((DyeColor)color);
                ComfortsRegistry.SLEEPING_BAGS.put((DyeColor)color, (Block)sleepingBag);
                HammockBlock hammock = new HammockBlock((DyeColor)color);
                ComfortsRegistry.HAMMOCKS.put((DyeColor)color, (Block)hammock);
                registry.registerAll((IForgeRegistryEntry[])new Block[]{sleepingBag, hammock});
            });
            registry.register((IForgeRegistryEntry)new RopeAndNailBlock());
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> evt) {
            IForgeRegistry registry = evt.getRegistry();
            ComfortsRegistry.SLEEPING_BAGS.values().forEach(block -> registry.register((IForgeRegistryEntry)new SleepingBagItem((Block)block)));
            ComfortsRegistry.HAMMOCKS.values().forEach(block -> registry.register((IForgeRegistryEntry)new HammockItem((Block)block)));
            registry.register((IForgeRegistryEntry)new ComfortsBaseItem(ComfortsRegistry.ROPE_AND_NAIL));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> evt) {
            TileEntityType sleepingBag = (TileEntityType)TileEntityType.Builder.func_223042_a(SleepingBagTileEntity::new, (Block[])ComfortsRegistry.SLEEPING_BAGS.values().toArray(new Block[0])).func_206865_a(null).setRegistryName(Comforts.MODID, "sleeping_bag");
            TileEntityType hammock = (TileEntityType)TileEntityType.Builder.func_223042_a(HammockTileEntity::new, (Block[])ComfortsRegistry.HAMMOCKS.values().toArray(new Block[0])).func_206865_a(null).setRegistryName(Comforts.MODID, "hammock");
            evt.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{sleepingBag, hammock});
        }
    }

    @Mod.EventBusSubscriber(modid="comforts", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent evt) {
            MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
            ClientRegistry.bindTileEntityRenderer(ComfortsRegistry.SLEEPING_BAG_TE, SleepingBagTileEntityRenderer::new);
            ClientRegistry.bindTileEntityRenderer(ComfortsRegistry.HAMMOCK_TE, HammockTileEntityRenderer::new);
            RenderTypeLookup.setRenderLayer((Block)ComfortsRegistry.ROPE_AND_NAIL, (RenderType)RenderType.func_228645_f_());
        }

        @SubscribeEvent
        public static void textureStitch(TextureStitchEvent.Pre evt) {
            if (evt.getMap().func_229223_g_() == AtlasTexture.field_110575_b) {
                for (DyeColor color : DyeColor.values()) {
                    evt.addSprite(new ResourceLocation(Comforts.MODID, "entity/hammock/" + color.func_176610_l()));
                    evt.addSprite(new ResourceLocation(Comforts.MODID, "entity/sleeping_bag/" + color.func_176610_l()));
                }
            }
        }
    }
}

