/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable;

import com.badlogic.gdx.controllers.ControllerAdapter;
import com.mrcrayfish.controllable.ButtonStates;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.ControllerEvents;
import com.mrcrayfish.controllable.client.ControllerInput;
import com.mrcrayfish.controllable.client.ControllerProperties;
import com.mrcrayfish.controllable.client.ControllerToast;
import com.mrcrayfish.controllable.client.GuiEvents;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.RenderEvents;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.settings.ControllerOptions;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.libsdl.SDL_Error;
import uk.co.electronstudio.sdl2gdx.SDL2Controller;
import uk.co.electronstudio.sdl2gdx.SDL2ControllerManager;

@Mod(value="controllable")
public class Controllable
extends ControllerAdapter {
    public static final Logger LOGGER = LogManager.getLogger((String)"Controllable");
    private static ControllerOptions options;
    private static SDL2ControllerManager manager;
    private static Controller controller;
    private static ControllerInput input;

    public Controllable() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    public static Controller getController() {
        return controller;
    }

    public static ControllerOptions getOptions() {
        return options;
    }

    public static ControllerInput getInput() {
        return input;
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        com.badlogic.gdx.controllers.Controller controller;
        Minecraft mc = (Minecraft)event.getMinecraftSupplier().get();
        File configFolder = new File(mc.field_71412_D, "config");
        ControllerProperties.load(configFolder);
        options = new ControllerOptions(mc.field_71412_D);
        manager = new SDL2ControllerManager();
        manager.addListenerAndRunForConnectedControllers(this);
        if (options.isAutoSelect() && Controllable.manager.getControllers().size > 0 && (controller = manager.getControllers().get(0)) instanceof SDL2Controller) {
            Controllable.setController((SDL2Controller)controller);
        }
        Mappings.load(configFolder);
        MinecraftForge.EVENT_BUS.register((Object)this);
        input = new ControllerInput();
        MinecraftForge.EVENT_BUS.register((Object)input);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new GuiEvents(manager));
        MinecraftForge.EVENT_BUS.register((Object)new ControllerEvents());
    }

    @Override
    public void connected(com.badlogic.gdx.controllers.Controller sdlController) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            if (sdlController instanceof SDL2Controller && controller == null) {
                if (options.isAutoSelect()) {
                    Controllable.setController((SDL2Controller)sdlController);
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g != null) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new ControllerToast(true, controller.getName()));
                }
            }
        });
    }

    @Override
    public void disconnected(com.badlogic.gdx.controllers.Controller sdlController) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            if (controller != null && controller.getSDL2Controller() == sdlController) {
                Controller oldController = controller;
                Controllable.setController(null);
                if (options.isAutoSelect() && Controllable.manager.getControllers().size > 0) {
                    Controllable.setController((SDL2Controller)manager.getControllers().get(0));
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g != null) {
                    Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new ControllerToast(false, oldController.getName()));
                }
            }
        });
    }

    public static void setController(@Nullable SDL2Controller sdl2Controller) {
        if (sdl2Controller != null) {
            Controller controller;
            Controllable.controller = controller = new Controller(sdl2Controller);
            Mappings.updateControllerMappings(controller);
        } else {
            controller = null;
        }
    }

    @SubscribeEvent
    public void handleButtonInput(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        try {
            manager.pollState();
        }
        catch (SDL_Error e) {
            e.printStackTrace();
        }
        if (controller == null) {
            return;
        }
        ButtonBinding.tick();
        Controller currentController = controller;
        this.processButton(0, this.getButtonState(0));
        this.processButton(1, this.getButtonState(1));
        this.processButton(2, this.getButtonState(2));
        this.processButton(3, this.getButtonState(3));
        this.processButton(4, this.getButtonState(4));
        this.processButton(5, this.getButtonState(5));
        this.processButton(6, this.getButtonState(6));
        this.processButton(7, this.getButtonState(7));
        this.processButton(8, this.getButtonState(8));
        this.processButton(9, this.getButtonState(9));
        this.processButton(10, this.getButtonState(10));
        this.processButton(11, Math.abs(currentController.getLTriggerValue()) >= 0.1f);
        this.processButton(12, Math.abs(currentController.getRTriggerValue()) >= 0.1f);
        this.processButton(13, this.getButtonState(11));
        this.processButton(14, this.getButtonState(12));
        this.processButton(15, this.getButtonState(13));
        this.processButton(16, this.getButtonState(14));
    }

    private void processButton(int index, boolean state) {
        if (Minecraft.func_71410_x().field_71462_r instanceof ControllerLayoutScreen && state && ((ControllerLayoutScreen)Minecraft.func_71410_x().field_71462_r).onButtonInput(index)) {
            return;
        }
        if (controller == null) {
            return;
        }
        if (controller.getMapping() != null) {
            index = controller.getMapping().remap(index);
        }
        if (index == -1) {
            return;
        }
        ButtonStates states = controller.getButtonsStates();
        if (state) {
            if (!states.getState(index)) {
                states.setState(index, true);
                input.handleButtonInput(controller, index, true);
            }
        } else if (states.getState(index)) {
            states.setState(index, false);
            input.handleButtonInput(controller, index, false);
        }
    }

    public static boolean isButtonPressed(int button) {
        return controller != null && controller.getButtonsStates().getState(button);
    }

    private boolean getButtonState(int buttonCode) {
        return controller != null && controller.getSDL2Controller().getButton(buttonCode);
    }
}

