/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import net.minecraft.client.Minecraft;
import net.minecraft.item.UseAction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ControllerEvents {
    private float prevHealth = -1.0f;

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerUsingItem(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntity() != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        if (!Controllable.getOptions().useForceFeedback()) {
            return;
        }
        if (Controllable.getInput().getLastUse() <= 0) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller != null) {
            float magnitudeFactor = 0.5f;
            UseAction action = event.getItem().func_77975_n();
            switch (action) {
                case BLOCK: {
                    magnitudeFactor = 0.25f;
                    break;
                }
                case SPEAR: {
                    magnitudeFactor = MathHelper.func_76131_a((float)((float)(event.getItem().func_77988_m() - event.getDuration()) / 20.0f), (float)0.0f, (float)0.25f) / 0.25f;
                    break;
                }
                case BOW: {
                    magnitudeFactor = MathHelper.func_76131_a((float)((float)(event.getItem().func_77988_m() - event.getDuration()) / 20.0f), (float)0.0f, (float)1.0f) / 1.0f;
                    break;
                }
                case CROSSBOW: {
                    magnitudeFactor = MathHelper.func_76131_a((float)((float)(event.getItem().func_77988_m() - event.getDuration()) / 20.0f), (float)0.0f, (float)1.5f) / 1.5f;
                }
            }
            controller.getSDL2Controller().rumble(0.5f * magnitudeFactor, 0.5f * magnitudeFactor, 50);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && Controllable.getOptions().useForceFeedback()) {
            if (this.prevHealth == -1.0f) {
                this.prevHealth = mc.field_71439_g.func_110143_aJ();
            } else if (this.prevHealth > mc.field_71439_g.func_110143_aJ()) {
                float difference = this.prevHealth - mc.field_71439_g.func_110143_aJ();
                float magnitude = difference / mc.field_71439_g.func_110138_aP();
                controller.getSDL2Controller().rumble(1.0f, 1.0f, (int)(800.0f * magnitude));
                this.prevHealth = mc.field_71439_g.func_110143_aJ();
            } else {
                this.prevHealth = mc.field_71439_g.func_110143_aJ();
            }
        } else if (this.prevHealth != -1.0f) {
            this.prevHealth = -1.0f;
        }
    }
}

