/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.CursorType;
import com.mrcrayfish.controllable.client.gui.ControllerLayoutScreen;
import com.mrcrayfish.controllable.event.ControllerEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.util.NativeUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemGroup;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ControllerInput {
    private static final ResourceLocation CURSOR_TEXTURE = new ResourceLocation("controllable", "textures/gui/cursor.png");
    private int lastUse = 0;
    private boolean keyboardSneaking = false;
    private boolean sneaking = false;
    private boolean isFlying = false;
    private boolean nearSlot = false;
    private double virtualMouseX;
    private double virtualMouseY;
    private float prevXAxis;
    private float prevYAxis;
    private int prevTargetMouseX;
    private int prevTargetMouseY;
    private int targetMouseX;
    private int targetMouseY;
    private double mouseSpeedX;
    private double mouseSpeedY;
    private boolean moved;
    private float targetPitch;
    private float targetYaw;
    private int dropCounter = -1;

    public double getVirtualMouseX() {
        return this.virtualMouseX;
    }

    public double getVirtualMouseY() {
        return this.virtualMouseY;
    }

    public int getLastUse() {
        return this.lastUse;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Screen screen;
            boolean moving;
            Controller controller;
            this.prevTargetMouseX = this.targetMouseX;
            this.prevTargetMouseY = this.targetMouseY;
            if (this.lastUse > 0) {
                --this.lastUse;
            }
            if ((controller = Controllable.getController()) == null) {
                return;
            }
            if (Math.abs(controller.getLTriggerValue()) >= 0.1f || Math.abs(controller.getRTriggerValue()) >= 0.1f) {
                this.lastUse = 100;
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71417_B.func_198035_h()) {
                return;
            }
            if (mc.field_71462_r == null || mc.field_71462_r instanceof ControllerLayoutScreen) {
                return;
            }
            float deadZone = (float)Controllable.getOptions().getDeadZone();
            boolean bl = moving = Math.abs(controller.getLThumbStickXValue()) >= deadZone || Math.abs(controller.getLThumbStickYValue()) >= deadZone;
            if (moving) {
                if (Math.abs(this.prevXAxis) < deadZone && Math.abs(this.prevYAxis) < deadZone) {
                    double mouseX = mc.field_71417_B.func_198024_e();
                    double mouseY = mc.field_71417_B.func_198026_f();
                    if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse()) {
                        mouseX = this.virtualMouseX;
                        mouseY = this.virtualMouseY;
                    }
                    this.prevTargetMouseX = this.targetMouseX = (int)mouseX;
                    this.prevTargetMouseY = this.targetMouseY = (int)mouseY;
                }
                float xAxis = (float)(controller.getLThumbStickXValue() > 0.0f ? 1 : -1) * Math.abs(controller.getLThumbStickXValue());
                this.mouseSpeedX = Math.abs(xAxis) >= deadZone ? (double)xAxis : 0.0;
                float yAxis = (float)(controller.getLThumbStickYValue() > 0.0f ? 1 : -1) * Math.abs(controller.getLThumbStickYValue());
                this.mouseSpeedY = Math.abs(yAxis) >= deadZone ? (double)yAxis : 0.0;
            }
            if (Math.abs(this.mouseSpeedX) > (double)0.05f || Math.abs(this.mouseSpeedY) > (double)0.05f) {
                double mouseSpeed = Controllable.getOptions().getMouseSpeed() * mc.func_228018_at_().func_198100_s();
                this.targetMouseX = (int)((double)this.targetMouseX + mouseSpeed * this.mouseSpeedX);
                this.targetMouseX = MathHelper.func_76125_a((int)this.targetMouseX, (int)0, (int)mc.func_228018_at_().func_198105_m());
                this.targetMouseY = (int)((double)this.targetMouseY + mouseSpeed * this.mouseSpeedY);
                this.targetMouseY = MathHelper.func_76125_a((int)this.targetMouseY, (int)0, (int)mc.func_228018_at_().func_198083_n());
                this.lastUse = 100;
                this.moved = true;
            }
            this.prevXAxis = controller.getLThumbStickXValue();
            this.prevYAxis = controller.getLThumbStickYValue();
            this.moveMouseToClosestSlot(moving, mc.field_71462_r);
            if (mc.field_71462_r instanceof CreativeScreen) {
                this.handleCreativeScrolling((CreativeScreen)mc.field_71462_r, controller);
            }
            if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse() && (screen = mc.field_71462_r) != null && (this.targetMouseX != this.prevTargetMouseX || this.targetMouseY != this.prevTargetMouseY) && mc.field_213279_p == null) {
                double mouseX = this.virtualMouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
                double mouseY = this.virtualMouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
                Screen.func_231153_a_(() -> screen.func_212927_b(mouseX, mouseY), (String)"mouseMoved event handler", (String)screen.getClass().getCanonicalName());
                if (mc.field_71417_B.field_198042_g != -1 && mc.field_71417_B.field_198045_j > 0.0) {
                    double dragX = (double)(this.targetMouseX - this.prevTargetMouseX) * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
                    double dragY = (double)(this.targetMouseY - this.prevTargetMouseY) * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
                    Screen.func_231153_a_(() -> {
                        if (ForgeHooksClient.onGuiMouseDragPre((Screen)screen, (double)mouseX, (double)mouseY, (int)mc.field_71417_B.field_198042_g, (double)dragX, (double)dragY)) {
                            return;
                        }
                        if (screen.func_231045_a_(mouseX, mouseY, mc.field_71417_B.field_198042_g, dragX, dragY)) {
                            return;
                        }
                        ForgeHooksClient.onGuiMouseDragPost((Screen)screen, (double)mouseX, (double)mouseY, (int)mc.field_71417_B.field_198042_g, (double)dragX, (double)dragY);
                    }, (String)"mouseDragged event handler", (String)screen.getClass().getCanonicalName());
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onScreenInit(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            this.nearSlot = false;
            this.moved = false;
            this.mouseSpeedX = 0.0;
            this.mouseSpeedY = 0.0;
            this.targetMouseX = this.prevTargetMouseX = (int)((float)mc.func_228018_at_().func_198105_m() / 2.0f);
            this.virtualMouseX = this.prevTargetMouseX;
            this.targetMouseY = this.prevTargetMouseY = (int)((float)mc.func_228018_at_().func_198083_n() / 2.0f);
            this.virtualMouseY = this.prevTargetMouseY;
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderScreen(GuiScreenEvent.DrawScreenEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r == null || this.targetMouseX == this.prevTargetMouseX && this.targetMouseY == this.prevTargetMouseY || mc.field_71462_r instanceof ControllerLayoutScreen)) {
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            double mouseX = (double)((float)this.prevTargetMouseX + (float)(this.targetMouseX - this.prevTargetMouseX) * partialTicks) + 0.5;
            double mouseY = (double)((float)this.prevTargetMouseY + (float)(this.targetMouseY - this.prevTargetMouseY) * partialTicks) + 0.5;
            if (Controllable.getOptions().isVirtualMouse()) {
                this.virtualMouseX = mouseX;
                this.virtualMouseY = mouseY;
            } else {
                GLFW.glfwSetCursorPos((long)mc.func_228018_at_().func_198092_i(), (double)mouseX, (double)mouseY);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse() && this.lastUse > 0) {
            RenderSystem.pushMatrix();
            CursorType type = Controllable.getOptions().getCursorType();
            Minecraft minecraft = event.getGui().getMinecraft();
            if (minecraft.field_71439_g == null || minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() || type == CursorType.CONSOLE) {
                double mouseX = (float)this.prevTargetMouseX + (float)(this.targetMouseX - this.prevTargetMouseX) * Minecraft.func_71410_x().func_184121_ak();
                double mouseY = (float)this.prevTargetMouseY + (float)(this.targetMouseY - this.prevTargetMouseY) * Minecraft.func_71410_x().func_184121_ak();
                RenderSystem.translated((double)(mouseX / minecraft.func_228018_at_().func_198100_s()), (double)(mouseY / minecraft.func_228018_at_().func_198100_s()), (double)500.0);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableLighting();
                event.getGui().getMinecraft().func_110434_K().func_110577_a(CURSOR_TEXTURE);
                if (type == CursorType.CONSOLE) {
                    RenderSystem.scaled((double)0.5, (double)0.5, (double)0.5);
                }
                Screen.func_238466_a_((MatrixStack)event.getMatrixStack(), (int)-8, (int)-8, (int)16, (int)16, (float)(this.nearSlot ? 16.0f : 0.0f), (float)(type.ordinal() * 16), (int)16, (int)16, (int)32, (int)(CursorType.values().length * 16));
            }
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent event) {
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (mc.field_71462_r == null && (this.targetYaw != 0.0f || this.targetPitch != 0.0f)) {
            float elapsedTicks = Minecraft.func_71410_x().func_193989_ak();
            player.func_195049_a((double)this.targetYaw / 0.15 * (double)elapsedTicks, (double)this.targetPitch / 0.15 * (double)(Controllable.getOptions().isInvertLook() ? -1 : 1) * (double)elapsedTicks);
            if (player.func_184187_bx() != null) {
                player.func_184187_bx().func_184190_l((Entity)player);
            }
        }
    }

    @SubscribeEvent
    public void onRender(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.targetYaw = 0.0f;
        this.targetPitch = 0.0f;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (mc.field_71462_r == null) {
            float deadZone = (float)Controllable.getOptions().getDeadZone();
            if (Math.abs(controller.getRThumbStickXValue()) >= deadZone || Math.abs(controller.getRThumbStickYValue()) >= deadZone) {
                this.lastUse = 100;
                double rotationSpeed = Controllable.getOptions().getRotationSpeed();
                ControllerEvent.Turn turnEvent = new ControllerEvent.Turn(controller, (float)rotationSpeed, (float)rotationSpeed * 0.75f);
                if (!MinecraftForge.EVENT_BUS.post((Event)turnEvent)) {
                    float deadZoneTrimX = (float)(controller.getRThumbStickXValue() > 0.0f ? 1 : -1) * deadZone;
                    this.targetYaw = turnEvent.getYawSpeed() * (controller.getRThumbStickXValue() - deadZoneTrimX) / (1.0f - deadZone) * 0.33f;
                    float deadZoneTrimY = (float)(controller.getRThumbStickYValue() > 0.0f ? 1 : -1) * deadZone;
                    this.targetPitch = turnEvent.getPitchSpeed() * (controller.getRThumbStickYValue() - deadZoneTrimY) / (1.0f - deadZone) * 0.33f;
                }
            }
        }
        if (mc.field_71462_r == null && ButtonBindings.DROP_ITEM.isButtonDown()) {
            this.lastUse = 100;
            ++this.dropCounter;
        }
        if (this.dropCounter > 20) {
            if (!mc.field_71439_g.func_175149_v()) {
                mc.field_71439_g.func_225609_n_(true);
            }
            this.dropCounter = 0;
        } else if (this.dropCounter > 0 && !ButtonBindings.DROP_ITEM.isButtonDown()) {
            if (!mc.field_71439_g.func_175149_v()) {
                mc.field_71439_g.func_225609_n_(false);
            }
            this.dropCounter = 0;
        }
    }

    @SubscribeEvent
    public void onInputUpdate(InputUpdateEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (this.keyboardSneaking && !mc.field_71474_y.field_228046_af_.func_151470_d()) {
            this.sneaking = false;
            this.keyboardSneaking = false;
        }
        if (mc.field_71474_y.field_228046_af_.func_151470_d()) {
            this.sneaking = true;
            this.keyboardSneaking = true;
        }
        if (mc.field_71439_g.field_71075_bZ.field_75100_b || mc.field_71439_g.func_184218_aH()) {
            this.lastUse = 100;
            this.sneaking = mc.field_71474_y.field_228046_af_.func_151470_d();
            this.sneaking |= ButtonBindings.SNEAK.isButtonDown();
            this.isFlying = true;
        } else if (this.isFlying) {
            this.sneaking = false;
            this.isFlying = false;
        }
        event.getMovementInput().field_228350_h_ = this.sneaking;
        if (mc.field_71462_r == null) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new ControllerEvent.Move(controller))) {
                int dir;
                float deadZone = (float)Controllable.getOptions().getDeadZone();
                if (Math.abs(controller.getLThumbStickYValue()) >= deadZone) {
                    this.lastUse = 100;
                    dir = controller.getLThumbStickYValue() > 0.0f ? -1 : 1;
                    event.getMovementInput().field_187255_c = dir > 0;
                    event.getMovementInput().field_187256_d = dir < 0;
                    event.getMovementInput().field_192832_b = (float)dir * MathHelper.func_76131_a((float)((Math.abs(controller.getLThumbStickYValue()) - deadZone) / (1.0f - deadZone)), (float)0.0f, (float)1.0f);
                    if (event.getMovementInput().field_228350_h_) {
                        event.getMovementInput().field_192832_b = (float)((double)event.getMovementInput().field_192832_b * 0.3);
                    }
                }
                if (Math.abs(controller.getLThumbStickXValue()) >= deadZone) {
                    this.lastUse = 100;
                    dir = controller.getLThumbStickXValue() > 0.0f ? -1 : 1;
                    event.getMovementInput().field_187258_f = dir < 0;
                    event.getMovementInput().field_187257_e = dir > 0;
                    event.getMovementInput().field_78902_a = (float)dir * MathHelper.func_76131_a((float)((Math.abs(controller.getLThumbStickXValue()) - deadZone) / (1.0f - deadZone)), (float)0.0f, (float)1.0f);
                    if (event.getMovementInput().field_228350_h_) {
                        event.getMovementInput().field_78902_a = (float)((double)event.getMovementInput().field_78902_a * 0.3);
                    }
                }
            }
            if (ButtonBindings.JUMP.isButtonDown()) {
                event.getMovementInput().field_78901_c = true;
            }
        }
        if (ButtonBindings.USE_ITEM.isButtonDown() && mc.field_71467_ac == 0 && !mc.field_71439_g.func_184587_cr()) {
            mc.func_147121_ag();
        }
    }

    public void handleButtonInput(Controller controller, int button, boolean state) {
        if (Minecraft.func_71410_x().field_71462_r instanceof ControllerLayoutScreen) {
            return;
        }
        this.lastUse = 100;
        ControllerEvent.ButtonInput eventInput = new ControllerEvent.ButtonInput(controller, button, state);
        if (MinecraftForge.EVENT_BUS.post((Event)eventInput)) {
            return;
        }
        button = eventInput.getModifiedButton();
        ButtonBinding.setButtonState(button, state);
        ControllerEvent.Button event = new ControllerEvent.Button(controller);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (state) {
            if (mc.field_71462_r == null) {
                if (ButtonBindings.INVENTORY.isButtonPressed()) {
                    if (mc.field_71442_b.func_110738_j()) {
                        mc.field_71439_g.func_175163_u();
                    } else {
                        mc.func_193032_ao().func_193296_a();
                        mc.func_147108_a((Screen)new InventoryScreen((PlayerEntity)mc.field_71439_g));
                    }
                } else if (ButtonBindings.SNEAK.isButtonPressed()) {
                    if (mc.field_71439_g != null && !mc.field_71439_g.field_71075_bZ.field_75100_b && !mc.field_71439_g.func_184218_aH()) {
                        this.sneaking = !this.sneaking;
                    }
                } else if (ButtonBindings.SCROLL_RIGHT.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.field_71071_by.func_195409_a(-1.0);
                    }
                } else if (ButtonBindings.SCROLL_LEFT.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.field_71439_g.field_71071_by.func_195409_a(1.0);
                    }
                } else if (ButtonBindings.SWAP_HANDS.isButtonPressed()) {
                    if (mc.field_71439_g != null && !mc.field_71439_g.func_175149_v() && mc.func_147114_u() != null) {
                        mc.func_147114_u().func_147297_a((IPacket)new CPlayerDiggingPacket(CPlayerDiggingPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.field_177992_a, Direction.DOWN));
                    }
                } else if (ButtonBindings.TOGGLE_PERSPECTIVE.isButtonPressed() && mc.field_71417_B.func_198035_h()) {
                    this.cycleThirdPersonView();
                } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                    if (mc.field_71439_g != null) {
                        mc.func_71385_j(false);
                    }
                } else if (mc.field_71439_g != null && !mc.field_71439_g.func_184587_cr()) {
                    if (ButtonBindings.ATTACK.isButtonPressed()) {
                        mc.func_147116_af();
                    } else if (ButtonBindings.USE_ITEM.isButtonPressed()) {
                        mc.func_147121_ag();
                    } else if (ButtonBindings.PICK_BLOCK.isButtonPressed()) {
                        mc.func_147112_ai();
                    }
                }
            } else if (ButtonBindings.INVENTORY.isButtonPressed()) {
                if (mc.field_71439_g != null) {
                    mc.field_71439_g.func_71053_j();
                }
            } else if (ButtonBindings.SCROLL_RIGHT.isButtonPressed()) {
                if (mc.field_71462_r instanceof CreativeScreen) {
                    this.scrollCreativeTabs((CreativeScreen)mc.field_71462_r, 1);
                }
            } else if (ButtonBindings.SCROLL_LEFT.isButtonPressed()) {
                if (mc.field_71462_r instanceof CreativeScreen) {
                    this.scrollCreativeTabs((CreativeScreen)mc.field_71462_r, -1);
                }
            } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                if (mc.field_71462_r instanceof IngameMenuScreen) {
                    mc.func_147108_a(null);
                }
            } else if (button == 0) {
                this.invokeMouseClick(mc.field_71462_r, 0);
            } else if (button == 2) {
                this.invokeMouseClick(mc.field_71462_r, 1);
            } else if (button == 1 && mc.field_71439_g != null && mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.invokeMouseClick(mc.field_71462_r, 0);
            }
        } else if (mc.field_71462_r != null) {
            if (button == 0) {
                this.invokeMouseReleased(mc.field_71462_r, 0);
            } else if (button == 2) {
                this.invokeMouseReleased(mc.field_71462_r, 1);
            }
        }
    }

    private void cycleThirdPersonView() {
        Minecraft mc = Minecraft.func_71410_x();
        ++mc.field_71474_y.field_74320_O;
        if (mc.field_71474_y.field_74320_O > 2) {
            mc.field_71474_y.field_74320_O = 0;
        }
        if (mc.field_71474_y.field_74320_O == 0) {
            mc.field_71460_t.func_175066_a(mc.func_175606_aa());
        } else if (mc.field_71474_y.field_74320_O == 1) {
            mc.field_71460_t.func_175066_a(null);
        }
    }

    private void scrollCreativeTabs(CreativeScreen creative, int dir) {
        this.lastUse = 100;
        try {
            Method method = ObfuscationReflectionHelper.findMethod(CreativeScreen.class, (String)"func_147050_b", (Class[])new Class[]{ItemGroup.class});
            method.setAccessible(true);
            if (dir > 0) {
                if (creative.func_147056_g() < ItemGroup.field_78032_a.length - 1) {
                    method.invoke((Object)creative, ItemGroup.field_78032_a[creative.func_147056_g() + 1]);
                }
            } else if (dir < 0 && creative.func_147056_g() > 0) {
                method.invoke((Object)creative, ItemGroup.field_78032_a[creative.func_147056_g() - 1]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void moveMouseToClosestSlot(boolean moving, Screen screen) {
        this.nearSlot = false;
        if (screen instanceof ContainerScreen) {
            if (!this.moved) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            ContainerScreen guiContainer = (ContainerScreen)screen;
            int guiLeft = (guiContainer.field_230708_k_ - guiContainer.getXSize()) / 2;
            int guiTop = (guiContainer.field_230709_l_ - guiContainer.getYSize()) / 2;
            int mouseX = (int)((double)this.targetMouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
            int mouseY = (int)((double)this.targetMouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
            Slot closestSlot = null;
            double closestDistance = -1.0;
            for (Slot slot : guiContainer.func_212873_a_().field_75151_b) {
                int posX = guiLeft + slot.field_75223_e + 8;
                int posY = guiTop + slot.field_75221_f + 8;
                double distance = Math.sqrt(Math.pow(posX - mouseX, 2.0) + Math.pow(posY - mouseY, 2.0));
                if (closestDistance != -1.0 && !(distance < closestDistance) || !(distance <= 14.0)) continue;
                closestSlot = slot;
                closestDistance = distance;
            }
            if (closestSlot != null && (closestSlot.func_75216_d() || !mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b())) {
                this.nearSlot = true;
                int slotCenterXScaled = guiLeft + closestSlot.field_75223_e + 8;
                int slotCenterYScaled = guiTop + closestSlot.field_75221_f + 8;
                int slotCenterX = (int)((double)slotCenterXScaled / ((double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m()));
                int slotCenterY = (int)((double)slotCenterYScaled / ((double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n()));
                double deltaX = slotCenterX - this.targetMouseX;
                double deltaY = slotCenterY - this.targetMouseY;
                if (!moving) {
                    if (mouseX != slotCenterXScaled || mouseY != slotCenterYScaled) {
                        this.targetMouseX = (int)((double)this.targetMouseX + deltaX * 0.75);
                        this.targetMouseY = (int)((double)this.targetMouseY + deltaY * 0.75);
                    } else {
                        this.mouseSpeedX = 0.0;
                        this.mouseSpeedY = 0.0;
                    }
                }
                this.mouseSpeedX *= 0.75;
                this.mouseSpeedY *= 0.75;
            } else {
                this.mouseSpeedX *= (double)0.1f;
                this.mouseSpeedY *= (double)0.1f;
            }
        } else {
            this.mouseSpeedX = 0.0;
            this.mouseSpeedY = 0.0;
        }
    }

    private void handleCreativeScrolling(CreativeScreen creative, Controller controller) {
        try {
            int i = (((CreativeScreen.CreativeContainer)creative.func_212873_a_()).field_148330_a.size() + 9 - 1) / 9 - 5;
            int dir = 0;
            if (controller.getSDL2Controller().getButton(11) || controller.getRThumbStickYValue() <= -0.8f) {
                dir = 1;
            } else if (controller.getSDL2Controller().getButton(12) || controller.getRThumbStickYValue() >= 0.8f) {
                dir = -1;
            }
            Field field = ObfuscationReflectionHelper.findField(CreativeScreen.class, (String)"field_147067_x");
            field.setAccessible(true);
            float currentScroll = field.getFloat(creative);
            currentScroll = (float)((double)currentScroll - (double)dir / (double)i);
            currentScroll = MathHelper.func_76131_a((float)currentScroll, (float)0.0f, (float)1.0f);
            field.setFloat(creative, currentScroll);
            ((CreativeScreen.CreativeContainer)creative.func_212873_a_()).func_148329_a(currentScroll);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void invokeMouseClick(Screen screen, int button) {
        Minecraft mc = Minecraft.func_71410_x();
        if (screen != null) {
            double mouseX = mc.field_71417_B.func_198024_e();
            double mouseY = mc.field_71417_B.func_198026_f();
            if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse() && this.lastUse > 0) {
                mouseX = this.virtualMouseX;
                mouseY = this.virtualMouseY;
            }
            mouseX = mouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
            mouseY = mouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
            mc.field_71417_B.field_198042_g = button;
            mc.field_71417_B.field_198045_j = NativeUtil.func_216394_b();
            double finalMouseX = mouseX;
            double finalMouseY = mouseY;
            Screen.func_231153_a_(() -> {
                boolean cancelled = ForgeHooksClient.onGuiMouseClickedPre((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)button);
                if (!cancelled) {
                    cancelled = screen.func_231044_a_(finalMouseX, finalMouseY, button);
                }
                if (!cancelled) {
                    ForgeHooksClient.onGuiMouseClickedPost((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)button);
                }
            }, (String)"mouseClicked event handler", (String)screen.getClass().getCanonicalName());
        }
    }

    private void invokeMouseReleased(Screen screen, int button) {
        Minecraft mc = Minecraft.func_71410_x();
        if (screen != null) {
            double mouseX = mc.field_71417_B.func_198024_e();
            double mouseY = mc.field_71417_B.func_198026_f();
            if (Controllable.getController() != null && Controllable.getOptions().isVirtualMouse() && this.lastUse > 0) {
                mouseX = this.virtualMouseX;
                mouseY = this.virtualMouseY;
            }
            mouseX = mouseX * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m();
            mouseY = mouseY * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n();
            mc.field_71417_B.field_198042_g = -1;
            double finalMouseX = mouseX;
            double finalMouseY = mouseY;
            Screen.func_231153_a_(() -> {
                boolean cancelled = ForgeHooksClient.onGuiMouseReleasedPre((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)button);
                if (!cancelled) {
                    cancelled = screen.func_231048_c_(finalMouseX, finalMouseY, button);
                }
                if (!cancelled) {
                    ForgeHooksClient.onGuiMouseReleasedPost((Screen)screen, (double)finalMouseX, (double)finalMouseY, (int)button);
                }
            }, (String)"mouseReleased event handler", (String)screen.getClass().getCanonicalName());
        }
    }
}

