/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.gui.ControllerSelectionScreen;
import com.mrcrayfish.controllable.client.gui.widget.ControllerButton;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import uk.co.electronstudio.sdl2gdx.SDL2ControllerManager;

public class GuiEvents {
    private static final List<RenderGameOverlayEvent.ElementType> EXCLUDED_TYPES;
    private SDL2ControllerManager manager;

    public GuiEvents(SDL2ControllerManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onOpenGui(GuiScreenEvent.InitGuiEvent.Post event) {
        ButtonBinding.resetButtonStates();
        if (event.getGui() instanceof OptionsScreen) {
            int y = event.getGui().field_230709_l_ / 6 + 72 - 6;
            event.addWidget((Widget)new ControllerButton(event.getGui().field_230708_k_ / 2 + 5 + 150 + 4, y, button -> Minecraft.func_71410_x().func_147108_a((Screen)new ControllerSelectionScreen(this.manager, event.getGui()))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (Controllable.getOptions().useConsoleHotbar()) {
            if (EXCLUDED_TYPES.contains(event.getType())) {
                return;
            }
            RenderSystem.translated((double)0.0, (double)-20.0, (double)0.0);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (Controllable.getOptions().useConsoleHotbar()) {
            if (EXCLUDED_TYPES.contains(event.getType())) {
                return;
            }
            RenderSystem.translated((double)0.0, (double)20.0, (double)0.0);
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)RenderGameOverlayEvent.ElementType.ALL);
        builder.add((Object)RenderGameOverlayEvent.ElementType.BOSSHEALTH);
        builder.add((Object)RenderGameOverlayEvent.ElementType.BOSSINFO);
        builder.add((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS);
        builder.add((Object)RenderGameOverlayEvent.ElementType.DEBUG);
        builder.add((Object)RenderGameOverlayEvent.ElementType.FPS_GRAPH);
        builder.add((Object)RenderGameOverlayEvent.ElementType.HELMET);
        builder.add((Object)RenderGameOverlayEvent.ElementType.PLAYER_LIST);
        builder.add((Object)RenderGameOverlayEvent.ElementType.PORTAL);
        builder.add((Object)RenderGameOverlayEvent.ElementType.POTION_ICONS);
        builder.add((Object)RenderGameOverlayEvent.ElementType.SUBTITLES);
        builder.add((Object)RenderGameOverlayEvent.ElementType.VIGNETTE);
        EXCLUDED_TYPES = builder.build();
    }
}

