/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.event.AvailableActionsEvent;
import com.mrcrayfish.controllable.event.RenderAvailableActionsEvent;
import com.mrcrayfish.controllable.event.RenderPlayerPreviewEvent;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderEvents {
    private static final ResourceLocation CONTROLLER_BUTTONS = new ResourceLocation("controllable", "textures/gui/buttons.png");
    private Map<Integer, Action> actions = new HashMap<Integer, Action>();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71439_g != null && !mc.field_71474_y.field_74319_N) {
            this.actions = new HashMap<Integer, Action>();
            if (mc.field_71462_r instanceof ContainerScreen) {
                if (mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    Slot slot;
                    ContainerScreen container = (ContainerScreen)mc.field_71462_r;
                    if (container.getSlotUnderMouse() != null && (slot = container.getSlotUnderMouse()).func_75216_d()) {
                        this.actions.put(0, new Action(I18n.func_135052_a((String)"controllable.action.pickup_stack", (Object[])new Object[0]), Action.Side.LEFT));
                        this.actions.put(2, new Action(I18n.func_135052_a((String)"controllable.action.pickup_item", (Object[])new Object[0]), Action.Side.LEFT));
                        this.actions.put(1, new Action(I18n.func_135052_a((String)"controllable.action.quick_move", (Object[])new Object[0]), Action.Side.LEFT));
                    }
                } else {
                    this.actions.put(0, new Action(I18n.func_135052_a((String)"controllable.action.place_stack", (Object[])new Object[0]), Action.Side.LEFT));
                    this.actions.put(2, new Action(I18n.func_135052_a((String)"controllable.action.place_item", (Object[])new Object[0]), Action.Side.LEFT));
                }
                this.actions.put(3, new Action(I18n.func_135052_a((String)"controllable.action.close_inventory", (Object[])new Object[0]), Action.Side.RIGHT));
            } else if (mc.field_71462_r == null) {
                ItemStack currentItem;
                ItemStack offHandStack;
                boolean blockHit = mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.BLOCK;
                boolean canOpenBlock = false;
                if (blockHit) {
                    BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)mc.field_71476_x;
                    canOpenBlock = mc.field_71441_e.func_180495_p(blockRayTraceResult.func_216350_a()).func_177230_c() instanceof ContainerBlock;
                }
                if (!mc.field_71439_g.func_184587_cr()) {
                    if (blockHit) {
                        this.actions.put(12, new Action(I18n.func_135052_a((String)"controllable.action.break", (Object[])new Object[0]), Action.Side.RIGHT));
                    } else {
                        this.actions.put(12, new Action(I18n.func_135052_a((String)"controllable.action.attack", (Object[])new Object[0]), Action.Side.RIGHT));
                    }
                }
                if ((offHandStack = mc.field_71439_g.func_184592_cb()).func_77975_n() != UseAction.NONE) {
                    switch (offHandStack.func_77975_n()) {
                        case EAT: {
                            if (!mc.field_71439_g.func_71024_bL().func_75121_c()) break;
                            this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.eat", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case DRINK: {
                            this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.drink", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case BLOCK: {
                            this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.block", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case BOW: {
                            this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.pull_bow", (Object[])new Object[0]), Action.Side.RIGHT));
                        }
                    }
                }
                if ((currentItem = mc.field_71439_g.field_71071_by.func_70448_g()).func_77975_n() != UseAction.NONE) {
                    switch (currentItem.func_77975_n()) {
                        case EAT: {
                            if (!mc.field_71439_g.func_71024_bL().func_75121_c()) break;
                            this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.eat", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case DRINK: {
                            this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.drink", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case BLOCK: {
                            this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.block", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case BOW: {
                            this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.pull_bow", (Object[])new Object[0]), Action.Side.RIGHT));
                        }
                    }
                } else if (currentItem.func_77973_b() instanceof BlockItem) {
                    if (blockHit) {
                        this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.place_block", (Object[])new Object[0]), Action.Side.RIGHT));
                    }
                } else if (!currentItem.func_190926_b() && !mc.field_71439_g.func_184587_cr()) {
                    this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.use_item", (Object[])new Object[0]), Action.Side.RIGHT));
                }
                if (!mc.field_71439_g.func_225608_bj_() && blockHit && canOpenBlock && !mc.field_71439_g.func_184587_cr()) {
                    this.actions.put(11, new Action(I18n.func_135052_a((String)"controllable.action.interact", (Object[])new Object[0]), Action.Side.RIGHT));
                }
                this.actions.put(3, new Action(I18n.func_135052_a((String)"controllable.action.inventory", (Object[])new Object[0]), Action.Side.LEFT));
                if (!mc.field_71439_g.func_184592_cb().func_190926_b() || !mc.field_71439_g.field_71071_by.func_70448_g().func_190926_b()) {
                    // empty if block
                }
                if (mc.field_71439_g.func_184218_aH()) {
                    this.actions.put(7, new Action(I18n.func_135052_a((String)"controllable.action.dismount", (Object[])new Object[0]), Action.Side.RIGHT));
                }
                if (!mc.field_71439_g.field_71071_by.func_70448_g().func_190926_b()) {
                    this.actions.put(14, new Action(I18n.func_135052_a((String)"controllable.action.drop_item", (Object[])new Object[0]), Action.Side.LEFT));
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new AvailableActionsEvent(this.actions));
        }
    }

    @SubscribeEvent
    public void onRenderScreen(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Controllable.getInput().getLastUse() <= 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74319_N) {
            return;
        }
        if (Controllable.getController() == null) {
            return;
        }
        RenderSystem.pushMatrix();
        if (!MinecraftForge.EVENT_BUS.post((Event)new RenderAvailableActionsEvent())) {
            IngameGui guiIngame = mc.field_71456_v;
            boolean isChatVisible = mc.field_71462_r == null && guiIngame.func_146158_b().field_146253_i.stream().anyMatch(chatLine -> guiIngame.func_73834_c() - chatLine.func_74540_b() < 200);
            int leftIndex = 0;
            int rightIndex = 0;
            for (Integer button : this.actions.keySet()) {
                Action action = this.actions.get(button);
                Action.Side side = action.getSide();
                int remappedButton = button;
                Controller controller = Controllable.getController();
                Mappings.Entry mapping = controller.getMapping();
                if (mapping != null) {
                    remappedButton = mapping.remap(button);
                }
                int texU = remappedButton * 13;
                int texV = Controllable.getOptions().getControllerType().ordinal() * 13;
                int size = 13;
                int x = side == Action.Side.LEFT ? 5 : mc.func_228018_at_().func_198107_o() - 5 - size;
                int y = mc.func_228018_at_().func_198087_p() + (side == Action.Side.LEFT ? leftIndex : rightIndex) * -15 - size - 5;
                mc.func_110434_K().func_110577_a(CONTROLLER_BUTTONS);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableLighting();
                if (isChatVisible && side == Action.Side.LEFT && leftIndex >= 2) continue;
                MatrixStack matrixStack = new MatrixStack();
                Widget.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)texU, (float)texV, (int)size, (int)size, (int)256, (int)256);
                if (side == Action.Side.LEFT) {
                    mc.field_71466_p.func_238421_b_(matrixStack, action.getDescription(), (float)(x + 18), (float)(y + 3), Color.WHITE.getRGB());
                    ++leftIndex;
                    continue;
                }
                int width = mc.field_71466_p.func_78256_a(action.getDescription());
                mc.field_71466_p.func_238421_b_(matrixStack, action.getDescription(), (float)(x - 5 - width), (float)(y + 3), Color.WHITE.getRGB());
                ++rightIndex;
            }
        }
        if (mc.field_71439_g != null && mc.field_71462_r == null && Controllable.getOptions().isRenderMiniPlayer() && !MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerPreviewEvent())) {
            InventoryScreen.func_228187_a_((int)20, (int)45, (int)20, (float)0.0f, (float)0.0f, (LivingEntity)mc.field_71439_g);
        }
        RenderSystem.popMatrix();
    }
}

