/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.controllable.client.Mappings;
import com.mrcrayfish.controllable.client.gui.ControllerAxis;
import com.mrcrayfish.controllable.client.gui.ControllerButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class ControllerLayoutScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("controllable", "textures/gui/controller.png");
    private List<ControllerButton> controllerButtons = new ArrayList<ControllerButton>();
    private int configureButton = -1;
    private Screen parentScreen;

    protected ControllerLayoutScreen(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("controllable.gui.title.layout"));
        this.parentScreen = parentScreen;
    }

    protected void func_231160_c_() {
        this.controllerButtons.add(new ControllerButton(0, 29, 9, 7, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(1, 32, 6, 13, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(2, 26, 6, 16, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(3, 29, 3, 10, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(9, 5, -2, 25, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(10, 26, -2, 32, 0, 7, 3, 5));
        this.controllerButtons.add(new ControllerButton(11, 5, -10, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(12, 26, -10, 39, 0, 7, 6, 5));
        this.controllerButtons.add(new ControllerButton(14, 6, 9, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(16, 9, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(15, 3, 6, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(13, 6, 3, 19, 0, 3, 3, 5));
        this.controllerButtons.add(new ControllerButton(4, 14, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(6, 21, 4, 22, 0, 3, 2, 5));
        this.controllerButtons.add(new ControllerButton(5, 17, 8, 46, 0, 4, 4, 5));
        this.controllerButtons.add(new ControllerAxis(7, 9, 12, 0, 0, 7, 7, 5));
        this.controllerButtons.add(new ControllerAxis(8, 22, 12, 0, 0, 7, 7, 5));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 32, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> this.field_230706_i_.func_147108_a(this.parentScreen)));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        int width = 190;
        int height = 145;
        int x = this.field_230708_k_ / 2 - width / 2;
        int y = this.field_230709_l_ / 2 - 50;
        ControllerLayoutScreen.func_238466_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)width, (int)height, (float)50.0f, (float)0.0f, (int)38, (int)29, (int)256, (int)256);
        RenderSystem.disableBlend();
        this.controllerButtons.forEach(controllerButton -> controllerButton.draw(matrixStack, x, y, mouseX, mouseY, this.configureButton == controllerButton.button));
        this.func_238472_a_(matrixStack, this.field_230712_o_, (ITextProperties)this.field_230704_d_, this.field_230708_k_ / 2, 20, 0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        ControllerButton button;
        if (mouseButton == 0 && (button = (ControllerButton)this.controllerButtons.stream().filter(ControllerButton::isHovered).findFirst().orElse(null)) != null) {
            this.configureButton = button.getButton();
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231046_a_(int key, int scanCode, int mods) {
        if (key == 256 && this.configureButton != -1) {
            this.configureButton = -1;
            return true;
        }
        return super.func_231046_a_(key, scanCode, mods);
    }

    public boolean onButtonInput(int button) {
        Controller controller;
        if (this.configureButton != -1 && (controller = Controllable.getController()) != null) {
            Mappings.Entry entry = controller.getMapping();
            if (entry == null) {
                entry = new Mappings.Entry(controller.getName(), controller.getName(), new HashMap<Integer, Integer>());
                controller.setMapping(entry);
            }
            if (button != this.configureButton) {
                entry.getReassignments().putIfAbsent((Object)this.configureButton, (Object)-1);
                entry.getReassignments().put((Object)button, (Object)this.configureButton);
            } else {
                Integer originalButton = (Integer)entry.getReassignments().inverse().get((Object)this.configureButton);
                if (originalButton != null) {
                    entry.getReassignments().remove((Object)originalButton);
                }
                entry.getReassignments().remove((Object)button);
            }
            this.configureButton = -1;
            entry.save();
            return true;
        }
        return false;
    }
}

